;;;  Loop Project Version 2 
;;;  control batch file for typechecking test files  
;;; 
;;; files contains the list of pvs files to typecheck 
;;; since there might be no valid pvs context it is important that 
;;; the files come in the right order  
;;; (do not forget ccsl-prelude.pvs !) 
;;; 
;;; use -batch option of the loop compiler to generate this file 
;;; 
;;; to start pvs in batch mode, type 
;;;     pvs -batch -v <verbos-value> -l <this file> 
;;; where verbose-value is between 0 and 3 
;;;
             
(setq files '(
	  "ccsl_prelude"
	  "Queue_basic"
	  "ListQueue_basic"
	  "Queue_model"
	  "ListQueue_model"
	  "Queue_theorem"
	  "Queue_refine"
	  "all"
	))

;;; the body: typecheck each of the files 

(setq current-prefix-arg t) 
(mapcar (lambda (f) 
	(message (concat "\n--> Typechecking " f)) 
	(typecheck f) 
	;(prove-pvs-file f) 
	) 
files) 
