
; root is a filename
; do prove-importchain on all theories in that file
(setq root-file "everything")

(typecheck root-file)

; determine root-theory as the first theory that we meet in root-file
; root-file should better contain only one theory, because
; only pvs knows in which order theories are reported
(setq root-theory)

(let ((all-theories (pvs-collect-theories)))
  (while (and all-theories (not root-theory))
    (if (equal root-file (car (cdr (car all-theories))))
	(setq root-theory (car (car all-theories))))
    (setq all-theories (cdr all-theories))))

(message "\n=====> determined %s as root theory <=====\n" root-theory)


; do an initial status to determine the number of proofs
(message "\n=====> initial status-proof-importchain <=====\n")

(let ((pvs-verbose 2))
  (status-proof-importchain root-theory))

(message "\n=====> end initial status-proof-importchain <=====\n")



(message "\n=====> prove-importchain %s <=====\n" root-theory)
(let ((current-prefix-arg 0))
  (prove-importchain root-theory)
  ; do a status to synchronize this script with pvs
  ; don't know if really necessary
  (status-proof-importchain root-theory))

(message "\n=====> status-proof-importchain <=====\n")

(let ((pvs-verbose 2))
  ;; (pvs-send-and-wait (format "(setq *pvs-verbose* %d)" pvs-verbose)
  ;; 		     nil nil 'dont-care)

  (status-proof-importchain root-theory))

(message "\n=====> end status-proof-importchain <=====\n")
