(*
 * The LOOP Project
 *
 * The LOOP Team, Dresden University and Nijmegen University
 *
 * Copyright (C) 2002
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License in file COPYING in this or one of the
 * parent directories for more details.
 *
 * Adapted from version 0.6.4 on  1.7.99 by Hendrik
 *
 * Time-stamp: <Monday 8 October 01 17:58:00 tews@ithif51>
 *
 * Interface of the Pretty printing module
 *
 * $Id: ccsl_pretty.mli,v 1.5 2002-05-03 15:01:06 tews Exp $
 *
 *)

open Top_variant_types
open Classtypes

    (******************************************************************
     *
     * pretty printing through the standart formatter
     *)
  
val ccsl_pp_type : ccsl_input_types -> unit

val ccsl_pp_expression : ccsl_expressions -> unit

val ccsl_pp_formula : ccsl_formulas -> unit


    (******************************************************************
     *
     * string interface
     *)

val string_of_ccsl_variance : variance_type -> string

val string_of_ccsl_type : ccsl_input_types -> string

val string_of_ccsl_inst_iface : ccsl_inst_iface_type -> string

val string_of_ccsl_arguments : ccsl_argument_type list -> string

val string_of_ccsl_expression : ccsl_expressions -> string

val string_of_ccsl_formula : ccsl_formulas -> string


(*** Local Variables: ***)
(*** version-control: t ***)
(*** kept-new-versions: 5 ***)
(*** delete-old-versions: t ***)
(*** time-stamp-line-limit: 30 ***)
(*** End: ***)

