(*
 * The LOOP Project
 *
 * The LOOP Team, Dresden University and Nijmegen University
 *
 * Copyright (C) 2002
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License in file COPYING in this or one of the
 * parent directories for more details.
 *
 * Created 24.6.02 by Hendrik
 *
 * Time-stamp: <Thursday 18 July 02 13:03:58 tews@ithif51>
 *
 * printing error messages
 *
 * $Id: error.mli,v 1.3 2002-07-18 13:43:26 tews Exp $
 *
 *)

open Global
open Top_variant_types
;;


    (* print an error on stderr;
     * this function returns normally, call your own exit *)
val print_error : string -> unit


    (* string representation of locations as used in warnings and errors *)
val string_of_loc : location_type -> string

    (* print message on stdout if in verbose mode *)
val print_verbose : string -> unit

    (* print a warning message on stderr *)
val warning_message : location_type -> string -> unit


    (* print an error message on stderr; 
     * this function returns normally, call your own exit *)
val error_message : location_type -> string -> unit

    (* print a pedanticness error message;
     * raise exceptions StrictnessViolation
     *)
val pedantic_error : location_type -> string -> 'a



(*** Local Variables: ***)
(*** version-control: t ***)
(*** kept-new-versions: 5 ***)
(*** delete-old-versions: t ***)
(*** time-stamp-line-limit: 30 ***)
(*** End: ***)
