(*
 * The LOOP Project
 *
 * The LOOP Team, Dresden University and Nijmegen University
 *
 * Copyright (C) 2002
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License in file COPYING in this or one of the
 * parent directories for more details.
 *
 * Created 14.5.99 by Hendrik
 *
 * Time-stamp: <Monday 8 October 01 17:58:00 tews@ithif51>
 *
 * generate batch file for pvs or Isabelle
 *
 * $Id: pvs_batch.mli,v 1.4 2002-05-03 15:01:18 tews Exp $
 *
 *)

open Top_classtypes

(***********************************************************************
 ***********************************************************************
 *
 * the main loop of the compiler iterates on single input files,
 * but the batch should contain everything, therefore you can register 
 * theories and generate the batch at the end
 *
 *)

val register_theories : 
  ( <get_file_name : string;..>, < .. >)
       #top_pre_theory_body_type list -> unit

    (* give file name as argument, the batch is created in the 
     * output_directory, if any 
     *)
val output_pvs_batch : string -> unit

val output_isa_batch : string -> unit

(*** Local Variables: ***)
(*** version-control: t ***)
(*** kept-new-versions: 5 ***)
(*** delete-old-versions: t ***)
(*** time-stamp-line-limit: 30 ***)
(*** End: ***)

