(* Loop Project -- Version II
   Created 11.10.01 by Hendrik
   Time-stamp: <Saturday 17 November 01 20:07:01 tews@ithif56.inf.tu-dresden.de>
   
   theories for empty coproduct

*)

open Name_space
open Names
open Top_variant_types  
open Pvs_proof_util
open Theory_class
open Iface_class
open Classtypes
open Types_util
;;

let emptytoken = { token_name = "";
		   loc = None 
		 }

let empty_iface = 
  new ccsl_pre_iface_class emptytoken (Symbol.new_local ()) true
;;   
empty_iface#inheritance_done
;;

(***********************************************************************
 ***********************************************************************
 *
 * empty type definition
 *
 *)

class ['class_type, 'member_type] ccsl_pre_empty_type_theory 
  (cl : 'class_type) 
  (* the equality relation for initializing the name space *)
  (eq_types : ('class_type, 'member_type) top_pre_types
     -> ('class_type, 'member_type) top_pre_types -> bool)

  : ['class_type, 'member_type] ccsl_pre_class_theory_type =
  object (self : 'self)

    inherit 
      ['class_type, 'member_type] ccsl_pre_class_theory_class cl eq_types
      as top_theory

       (* reserve all names, that we want to declare *)
    initializer reserve ns 
      (
       [ name_of_empty_type;
       ]
      )

    method get_name = ccsl_empty_type_defn_theory_name

    method get_parameters = []

    initializer top_theory#override_file_name ccsl_prelude_name

    method get_proofs = []


    method private emptytype =
      let bool_var = "b" 
      in
	Typedecl(
	  [],
	  name_of_empty_type,
	  Predtype(
	    Formula(
	      Abstraction(
		[bool_var, Bool],
		Expression(False)))))
	      

    method make_body = 
      [      
	self#emptytype
      ]

end (* ccsl_pre_empty_type_theory *)

class ccsl_empty_type_theory = 
  [ccsl_iface_type, ccsl_member_type] 
  ccsl_pre_empty_type_theory
    empty_iface
    eq_ccsl_types


(***********************************************************************
 ***********************************************************************
 *
 * empty function definition
 *
 *)

class ['class_type, 'member_type] ccsl_pre_empty_fun_theory 
  (cl : 'class_type) 
  (* the equality relation for initializing the name space *)
  (eq_types : ('class_type, 'member_type) top_pre_types
     -> ('class_type, 'member_type) top_pre_types -> bool)

  : ['class_type, 'member_type] ccsl_pre_class_theory_type =
  object (self : 'self)

    inherit 
      ['class_type, 'member_type] ccsl_pre_class_theory_class cl eq_types
      as top_theory

       (* reserve all names, that we want to declare *)
    initializer reserve ns 
      (
       [ name_of_empty_fun;
       ]
      )

    val other_type_id = 
		 { id_token = { token_name = "A";
				loc = None };
		   (* the other fields are to ignored *)
		   id_type = Self;
		   id_origin = CCSL_TypeParameter;
		   id_parameters = [];
		   id_variance = Unset;
		 }

    method get_name = ccsl_empty_fun_theory_name

    method get_parameters = [TypeParameter other_type_id]

    initializer top_theory#override_file_name ccsl_prelude_name

    method get_proofs = []

    method private fundefn =
      let empty_type = TypeConstant(name_of_empty_type,Always,[]) in
      let other_type = BoundTypeVariable other_type_id in
      let empty_var = "z" in
      let other_var = "a" 
      in
	Defn(
	  name_of_empty_fun,
	  [],
	  (Function(empty_type, other_type)),
	  Abstraction(
	    [empty_var, empty_type],
	    Application(
	      Term("epsilon",Always,[]),
	      Abstraction(
		[other_var, other_type],
		Expression True))))
	

    method private singlefun =
      let proof = make_simple_proof [skosimp_star; extensionality] in
      let empty_type = TypeConstant(name_of_empty_type,Always,[]) in
      let other_type = BoundTypeVariable other_type_id in
      let other_f = "f" in
      let lem =
	Lemma(
	  name_of_unique_empty_fun_lemma,
	  Forall(
	    [other_f, Function(empty_type, other_type)],
	    Equal(
	      Term(other_f,Always,[]), 
		   Term(name_of_empty_fun, Always,[]))))
      in
	Proved( lem, Anon_proof proof)
	  

    method make_body = 
      [      
	Import( [ccsl_empty_type_defn_theory_name, []]);
	self#fundefn;
	self#singlefun
      ]

end (* ccsl_pre_empty_fun_theory *)

class ccsl_empty_fun_theory = 
  [ccsl_iface_type, ccsl_member_type] 
  ccsl_pre_empty_fun_theory
    empty_iface
    eq_ccsl_types






(*** Local Variables: ***)
(*** version-control: t ***)
(*** kept-new-versions: 5 ***)
(*** delete-old-versions: t ***)
(*** End: ***)


