(*
 * The LOOP Project
 *
 * The LOOP Team, Dresden University and Nijmegen University
 *
 * Copyright (C) 2002
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License in file COPYING in this or one of the
 * parent directories for more details.
 *
 * Created 14.5.99 by Hendrik
 *
 * Time-stamp: <Monday 8 October 01 17:58:00 tews@ithif51>
 *
 * the class for ccsl adt's and classes
 *
 * $Id: iface_class.ml,v 1.13 2002/01/23 16:00:15 tews Exp $
 *
 *)

open Util
open Global
open Top_variant_types
open Top_variant_types_util
open Top_classes
open Classtypes
open Types_util
open Interface_theory
open Methodinv_theory
open Bisim_theory
open Morphism_theory
open Full_liftings_theory
open Semantics_theory
open Adt_theory;;


class ['member_type, 'theory_body_type, 'super_class] ccsl_pre_iface_class
  name					(* the token *)
  local 				(* the local table *)
  prelude_flag				(* true for the prelude *)
  : ['member_type, 'theory_body_type, 'super_class] ccsl_pre_iface_type 
  = 
  object (self : 'self)

    inherit ['member_type, 'theory_body_type, 'super_class] 
      top_pre_iface_class name local
      as top_iface

  (*
    constraint 'member_type = 'super_class #ccsl_pre_member_type
  *)

    (*******************************************************************
     *
     * new features
     *)

    method belongs_to_prelude = (prelude_flag : bool)


      (* convenience method has_constructors, 
       * tells if self#get_constructors <> [] 
       * recorded in add_member
       *)

    val mutable has_constructors = false

    method has_constructors = has_constructors


    (*******************************************************************
     * final or loose model coalgebra
     *)

    method get_model_coalgebra =
      if self#has_feature FinalSemanticsFeature
      then Term(Top_names.name_of_final_coalgebra self, Always,[])
      else Term(Top_names.name_of_loose_coalgebra self, Always,[])

    method get_model_algebra =
      if self#has_feature FinalSemanticsFeature
      then Term(Names.name_of_algebra_final self, Always,[])
      else Term(Names.name_of_algebra_loose self, Always,[])

    method get_model_type_argument args =
      let typename = 
	if self#has_feature FinalSemanticsFeature
	then Top_names.name_of_final_type self
	else Top_names.name_of_loose_type self
      in
	TypeArgument(TypeConstant(typename,Always,args))

    (*******************************************************************
     *
     * Instanciations
     *)

	(* instanciated classes have less features *)
    val mutable instanciated = false 

    method become_instanciated = instanciated <- true

    method is_instanciated = instanciated

    val mutable arguments = []

    method set_arguments args =
      arguments <- args

    method get_arguments =
      assert(instanciated);
      arguments

    (*******************************************************************
     *
     * variances
     *)

    val mutable self_var = Unset

    method get_self_variance = self_var

    method set_self_variance var = self_var <- var


    val mutable functor_type = UnknownFunctor

    method get_functor_type = functor_type

    method set_functor_type ft = functor_type <- ft

    (*******************************************************************
     *
     * inheritance
     *)

	(* During inheritance ancestor classes get 
	 * first instanciated, then in the instanciated copy
	 * the heir is set to the non-instanciated class that inherits
	 *)
    val mutable inherited_in = (None : 'super_class option)

    method inherit_to heir = 
      assert(instanciated && inheritance_ready);
      inherited_in <- Some heir;
      List.iter (fun acl -> acl#inherit_to heir) 
	(self#get_resolved_ancestors)

    method get_heir = 
      assert(inheritance_ready);
      inherited_in

    (*******************************************************************
     *
     * importings
     *)
  
    val mutable iface_importings = []
    val mutable assertion_importings = []

    method add_iface_import i = 
      assert(not instanciated);
      iface_importings <- iface_importings @ [i]

    method get_iface_imports = 
      assert(not instanciated);
      iface_importings

    method add_assertion_import i = 
      assert(not instanciated);
      assertion_importings <- assertion_importings @ [i]

    method get_assertion_imports = 
      assert(not instanciated);
      assertion_importings

    (*******************************************************************
     *
     * parameters and arguments
     *)

    val mutable parameters = 
      ( [] : ('super_class, 'member_type) top_pre_parameter_type list)

    method add_parameter p = 
      assert(not instanciated);
      parameters <- parameters @ [p]

    method get_parameters = 
      assert(not instanciated);
      parameters

    method check_parameters args = 
      assert(not instanciated);
      check_parameters parameters args

    (*******************************************************************
     *
     * components
     *)

    val mutable components = 
      ([] : ('super_class, 'member_type) top_pre_component_type list)

      (* 
       * all components with all instanciations must be added !!
       * it is the responsibility of the caller, to traverse the 
       * argument list and add components in there first
       * see iter_component_arg and iter_components
       *)
    method add_component comp =
      let (v, c, args) = comp in 
      let rec do_it = function
	| ((v',c',args') as comp') :: l ->
	    if ((c'#get_name = c#get_name) &&
		(List.for_all2 eq_ccsl_args args args'))
	    then
	      ((Logic_util.variance_join v v'), c', args') :: l
	    else comp' :: (do_it l)
	| [] -> [comp]
      in
      	components <- do_it components

    method get_components = components

    (*******************************************************************
     *
     * ancestors
     *)

     (* override, to treat components *)
    method add_ancestor a =
      assert(not instanciated);
(* not needed (I hope)
 *       (match a with 
 * 	 | Unresolved_renaming(anc,args,renamings) ->
 * 				   (* get components for the instanciation *)
 * 		iter_component_arglist true
 * 		  (fun c -> self#add_component c)
 * 		  args
 *
 *	 | _ -> (assert (false); raise Internal_error)
 *      );
 *)
      top_iface#add_ancestor a


	(* override *)
    method get_resolved_ancestors =
      assert(inheritance_ready);
      top_iface#get_resolved_ancestors


    (*******************************************************************
     *
     * members
     * 
     * override add_member to treat components
     *)

    method add_member m =
      Symbol.create_local local m#get_name (MemberSymb m);
(* component_pass
 * 	 (match m#get_sort with
 * 	    | Adt_Reduce | Class_Coreduce -> ()
 * 	    | _ -> 
 * 		begin
 * 		  iter_components false (fun c -> self#add_component c)
 * 		    m#get_domain;
 * 		  iter_components true (fun c -> self#add_component c)
 * 		    m#get_codomain
 * 		end
 * 	 );
 *)
      if not has_constructors && m#is_constructor 
      then has_constructors <- true;
      top_iface#add_member m
	

    (*******************************************************************
     *
     * local symboltables
     * 
     *)

	(* filled in inheritance pass, retained in instanciations 
	 * contains also the own local table
	 *)
    val mutable inherited_locals =
      ([local] : ('super_class, 'member_type) top_pre_scope_type list)

    method get_inherited_locals = inherited_locals

    method inherit_locals locs = 
      inherited_locals <- inherited_locals @ locs

      (* search in the local symboltable of this class *)
    method find_local name = Table.find_local local CCSL_ID name 

    (* The next two functions were in top_iface before, but 
     * the symboltable is so different, that they make no sense there
     *
     * find a member, among all (also inherited members
     * a call is only valid, if the inheritance pass is done
     * maybe raise Member_not_found
     *)
    method find_member name =
      let _ = assert (inheritance_ready) in
      let rec doit = function
	| [] -> raise Member_not_found
	| loc :: rest -> 
	    try
	      (match Table.find_local loc CCSL_ID name with
		| MemberSymb m -> m
			(* a method is always stored as Member *)
		| _ -> raise Member_not_found
	      )
	    with Table.Not_defined -> doit rest
      in
	doit inherited_locals

    (* find a member in this class
     * maybe raise Member_not_found
     *)
    method find_local_member name =
      try
	match self#find_local name with
	  | MemberSymb m -> m
			(* a method is always stored as Member *)
	  | _ -> raise Member_not_found
      with Table.Not_defined -> raise Member_not_found

    (*******************************************************************
     *
     * definitional extensions
     *)

    val mutable definitions = [] 

    method add_definition def =
      self#add_member def.defined_method;
      definitions <- definitions @ [def]

    method get_definitions = definitions

    (*******************************************************************
     *
     * assertions and creation conditions
     *)

    val mutable assertions = 
      ( [] : ('super_class, 'member_type) top_pre_assertion_record list)
    val mutable creations = 
      ( [] : ('super_class, 'member_type) top_pre_assertion_record list)

    method add_assertion a = 
      assert(not instanciated);
      assertions <- assertions @ [a]

    method get_assertions = assertions

    method set_assertions ass =
      assertions <- ass

    method add_creation c = 
      assert(not instanciated);
      creations <- creations @ [c]

    method get_creations = creations

    method set_creations cre =
      creations <- cre

    (*******************************************************************
     *
     * Liftings, doku see iface_type 
     *)

    val mutable lifting_requests = 
      ([] : (string * ('super_class, 'member_type) top_pre_types) list)

    method add_lifting name typ =
      lifting_requests <- lifting_requests @ [name,typ]

    method get_lifting_requests = lifting_requests

    (*******************************************************************
     *
     * Relation Liftings, doku see iface_type 
     *)
	
    val mutable rel_lifting_requests = 
      ([] : (('super_class, 'member_type) top_pre_types * string) list)
      
    val mutable rel_lifting_num = 0
      
    method add_rel_lifting name typ =
      if List.exists
	(fun (t,n) -> (n = name) & (eq_ccsl_types typ t))
	rel_lifting_requests
      then
	()
      else
	let nname = 
	  if name = "" then
	    begin
	      rel_lifting_num <- rel_lifting_num +1;
	      self#get_name ^ "ObsEq_" ^ (string_of_int rel_lifting_num)
	    end
	  else
	    name
	in
	  begin
(* 	       iter_components true (fun c -> self#add_component c) typ;
 *)
	    rel_lifting_requests <- rel_lifting_requests @ [typ,nname]
	  end

	
    method get_rel_lifting_requests = rel_lifting_requests

    method find_rel_lifting_for_type typ = 
      Util.assoc eq_ccsl_types typ rel_lifting_requests

    (*******************************************************************
     *
     * Theory generation
     *)

    method generate_all_theories =
      let _ = assert(not instanciated) in
					(* do some type conversion first *)
      let self'  : ('member_type, 'theory_body_type, 'super_class) 
 	ccsl_pre_iface_type  = 
	(self :> ('member_type, 'theory_body_type, 'super_class) 
	   ccsl_pre_iface_type) 
	in
      let class_typeconvert 
	(th : ccsl_class_theory_type ) =
	(th :> (('member_type, 'theory_body_type, 'super_class)
		  ccsl_pre_iface_type,
		  ('super_class, 'member_type) ccsl_pre_member_type)
	       ccsl_pre_theory_body_type) in
      let adt_typeconvert 
	(th : ccsl_adt_theory_type ) =
	(th :> (('member_type, 'theory_body_type, 'super_class)
	          ccsl_pre_iface_type,
		  ('super_class, 'member_type) ccsl_pre_member_type)
	       ccsl_pre_theory_body_type) in
      match self#get_kind with 
					(* generate classes *)
  	| Spec_class ->			
	    [(class_typeconvert (new ccsl_interface_theory self' ));
	     (class_typeconvert (new ccsl_method_lift_theory self'));
(* 		(class_typeconvert
 * 		   (new ccsl_lift_theory self'));
 * 		(class_typeconvert
 * 		   (new ccsl_private_invariance_rewrite_theory self'));
 * 		(class_typeconvert
 * 		   (new ccsl_public_invariance_rewrite_theory self'));
 *)
	     (class_typeconvert
		(new ccsl_method_invariance_rewrite_theory self'));
(* Jan: what is this GI stuff good for ??
 *	     (class_typeconvert
 *		(new ccsl_greatest_invariance_theory self'));
 * !!!  I also changed the importing in the box theory !!!
 *)
	     (class_typeconvert
		(new ccsl_box_theory self'))
	    ] @ ( 

	      if (!ccsl_generate_paths) then
		[ (adt_typeconvert
		     (new ccsl_step_adt self'));
		  (class_typeconvert
		     (new ccsl_path_theory self'))]
	      else
		[]
	    ) @ (
	      if self#has_feature HasBisimulationFeature then
		[
		  (class_typeconvert 
	             (new ccsl_bibisim_theory self'))
		] @ (
		  if self#has_feature HasGreatestBisimFeature
		  then
		    [
		      (class_typeconvert 
			 (new ccsl_private_bibisim_rewrite_theory self'));
		      (class_typeconvert 
			 (new ccsl_public_bibisim_rewrite_theory self'))
		    ]
		  else 
		    []
		) @ [
		  (class_typeconvert 
	             (new ccsl_bisim_eq_theory self'))
		] @ (
		  if self#has_feature HasGreatestBisimFeature
		  then
		    [
		      (class_typeconvert 
			 (new ccsl_private_bisim_eq_rewrite_theory self'));
		      (class_typeconvert 
			 (new ccsl_public_bisim_eq_rewrite_theory self'))
		    ]
		  else
		    []
		)
	      else
		[]
	    ) @ (
	      if self#get_rel_lifting_requests = [] then 
		[]
	      else 
		[ (class_typeconvert
		     (new ccsl_req_bisim_theory self'))
		]
	    ) @ [
	      (class_typeconvert 
	         (new ccsl_semantics_theory self'));
	      (class_typeconvert 
	         (new ccsl_basic_theory self'));
              (class_typeconvert
                 (new ccsl_full_invariant_theory self'));
	    ] @ (

	      if self#has_feature HasFullRelLiftingFeature then
		[
		  (class_typeconvert
                     (new ccsl_full_bibisim_theory self'));
		]
	      else
		[]
	    ) @ (

	      if self#has_feature HasMorphismFeature
	      then 
		[
		  (class_typeconvert 
		     (new ccsl_morphism_theory self'));
		  (class_typeconvert 
		     (new ccsl_morphism_rewrite_theory self'));
		  (class_typeconvert 
		     (new ccsl_finality_theory self'));
		]
	      else []

	    ) @ (

	    if self#has_feature FinalSemanticsFeature then
	      [
		(class_typeconvert (new ccsl_final_theory self'));
		(class_typeconvert (new ccsl_final_props_theory self'));
	      ] @ (
		if self#has_feature HasMapFeature then
		  [
		    (class_typeconvert (new ccsl_map_struct_theory self'));
		    (class_typeconvert (new ccsl_map_theory self'));
		  ]
		else
		  []
	      )
	    else
	     [
	       (class_typeconvert (new ccsl_loose_theory self'));
	     ]
	    ) @
	    [
	     (class_typeconvert (new ccsl_coadt_theory self'));
	    ]
					(* generate adt's *)
  	| Spec_adt -> 
	    (match !output_mode with
	       | Pvs_mode -> 
		   if self#has_feature BuildinFeature
		   then []
		   else
		     [adt_typeconvert (new ccsl_pvs_adt_theory self')]
	       | Isa_mode ->
		   (if self#has_feature BuildinFeature
		    then []
		    else 
		      [adt_typeconvert (new ccsl_isa_adt_theory self')]
		   )
		   @
		   [
		    adt_typeconvert (new ccsl_isa_adtutil_theory self')
		   ]
	    ) @ (
	      if self#has_feature NeedsMapFeature 
	      then
		[
		  adt_typeconvert (new ccsl_adt_map_theory self');
		  adt_typeconvert (new ccsl_adt_every_theory self')
		]
	      else
		[]
	    ) @ (
	      if self#has_feature HasRelLiftFeature
	      then
		[adt_typeconvert (new ccsl_adt_rellift_theory self')
		]
	      else
		[]
	    )

	| Spec_sig
  	| Spec_Spec 
	  -> (assert(false); raise Internal_error)
	  
    (*******************************************************************
     *
     * Signature stuff
     *)

    val mutable ground_types = 
        ( [] : 
	    ('super_class, 'member_type) top_pre_identifier_record_type list)

    method add_ground_type gt  = 
      assert(self#get_kind = Spec_sig);
      Symbol.create_local local gt.id_token.token_name
	(CCSL_GroundTypeSymb gt);
      ground_types <- ground_types @ [gt]

    method get_all_ground_types = 
      assert(self#get_kind = Spec_sig);
      ground_types

    (*******************************************************************
     *
     * Dumping
     *)

    method dump_iface =
      (if instanciated then "INSTANCIATED" else "") ^
      top_iface#dump_iface ^
      "Parameters: " ^ (dump_list dump_parameter "| " parameters) ^ "\n"
      

    (*******************************************************************
     *
     * override section
     *)



  end (* of ccsl_pre_iface_class *)



(*** Local Variables: ***)
(*** version-control: t ***)
(*** kept-new-versions: 5 ***)
(*** delete-old-versions: t ***)
(*** End: ***)

