(*
 * The LOOP Project
 *
 * The LOOP Team, Dresden University and Nijmegen University
 *
 * Copyright (C) 2002
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License in file COPYING in this or one of the
 * parent directories for more details.
 *
 * Created 1.10.97 by Hendrik
 *
 * Time-stamp: <Monday 8 October 01 17:58:00 tews@ithif51>
 *
 * make a wrapper around the Format module for reentrance support 
 *
 * $Id: formatter.mli,v 1.3 2002/01/23 16:00:22 tews Exp $
 *
 *)

    (******************************************************************
     *
     * standart formatter functions from standart Format lib
     * look at Format module for documentation
     *)
  
val open_box : int -> unit
val close_box : unit -> unit
val print_string : string -> unit
val print_as : int -> string -> unit
val print_int : int -> unit
val print_float : float -> unit
val print_char : char -> unit
val print_bool : bool -> unit
val print_space : unit -> unit
val print_cut : unit -> unit
val print_break : int -> int -> unit
val print_flush : unit -> unit
val print_newline : unit -> unit
val force_newline : unit -> unit
val print_if_newline : unit -> unit
val set_margin : int -> unit
val get_margin : unit -> int
val set_max_indent : int -> unit
val get_max_indent : unit -> int
val set_max_boxes : int -> unit
val get_max_boxes : unit -> int
val over_max_boxes : unit -> bool
val open_hbox : unit -> unit
val open_vbox : int -> unit
val open_hvbox : int -> unit
val open_hovbox : int -> unit
val open_tbox : unit -> unit
val close_tbox : unit -> unit
val print_tbreak : int -> int -> unit
val set_tab : unit -> unit
val print_tab : unit -> unit
val set_ellipsis_text : string -> unit
val get_ellipsis_text : unit -> string
val set_formatter_out_channel : out_channel -> unit
val set_formatter_output_functions :
  (string -> int -> int -> unit) -> (unit -> unit) -> unit;;
val get_formatter_output_functions :
  unit -> (string -> int -> int -> unit) * (unit -> unit);;
val set_all_formatter_output_functions :
      (string -> int -> int -> unit) -> (unit -> unit) ->
      (unit -> unit) -> (int -> unit) -> unit
val get_all_formatter_output_functions : unit ->
        (string -> int -> int -> unit) * (unit -> unit) *
        (unit -> unit) * (int -> unit)

(* printf and friends are not supported, I was to lazy. *)

    (******************************************************************
     *
     * reentrance support
     *
     * this implements a stack of formatters, 
     * after push the obove functions use a *new* formatter with 
     *     the same output and flush functions
     * after corresponding pop previous formatting can be continued
     *)

val push_formatter : Format.formatter -> unit
val pop_formatter : unit -> unit

val stringwrapper : ('a -> unit) -> 'a -> string


(*** Local Variables: ***)
(*** version-control: t ***)
(*** kept-new-versions: 5 ***)
(*** delete-old-versions: t ***)
(*** End: ***)

