(*
 * The LOOP Project
 *
 * The LOOP Team, Dresden University and Nijmegen University
 *
 * Copyright (C) 2002
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License in file COPYING in this or one of the
 * parent directories for more details.
 *
 * Created 26.1.99 by Hendrik
 *
 * Time-stamp: <Monday 8 October 01 17:58:00 tews@ithif51>
 *
 * Utility functions and variables used in _all_ parsers
 *
 * $Id: parser_util.ml,v 1.3 2002/01/23 16:00:23 tews Exp $
 *
 *)

(***********************************************************************
 ***********************************************************************
 *
 * module implementation
 *
 *)

open Global
open Top_variant_types;;
open Top_variant_types_util;;
open Top_classes;;

    (* current line number
     *)
let line = ref 1

    (* holds the global byte offset wrt the current file of the
     * start of the current line
     *)
let line_start = ref 0

    (* lexer action when newline is read in
     *)
let newline pos = incr(line); line_start := pos

    (* reset the line number to one again. *)
let reset_line () = 
  line := 1;
  line_start := 0

    (* build a token for the current line, if there is no 
     * token available in the context 
     *)
let emergency_token () = 
  { token_name = "";
    loc = None 
  }


(*** Local Variables: ***)
(*** version-control: t ***)
(*** kept-new-versions: 5 ***)
(*** delete-old-versions: t ***)
(*** End: ***)

