(*
 * The LOOP Project
 *
 * The LOOP Team, Dresden University and Nijmegen University
 *
 * Copyright (C) 2002
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License in file COPYING in this or one of the
 * parent directories for more details.
 *
 * Created 26.6.99 by Hendrik
 *
 * Time-stamp: <Monday 8 October 01 17:58:00 tews@ithif51>
 *
 * string representation for items used in both translations, 
 *
 * $Id: top_names.ml,v 1.6 2002/01/23 16:00:24 tews Exp $
 *
 *)

open Global
open Util
open Top_variant_types

let name_of_pvs_batch = "pvs-batch.el"

let name_of_isa_batch = "ROOT.ML"

(* 
 * let isabelle_top_theory = "Main"
 *)

(* *)
let isabelle_top_theory = "CCSLMain"
(* *)

let name_of_method_functor cl = cl#get_name ^ "Signature"

let name_of_type_of_adt adt = adt#get_name

let name_of_self () = "Self"

let name_of_loose_type cl = "L" ^ cl#get_name

let name_of_final_type cl = "F" ^ cl#get_name

let name_of_type_of_adt adt = adt#get_name

let name_of_class_every cl =
  match !output_mode with
    | Pvs_mode -> "Every" ^ cl#get_name
    | Isa_mode -> "Every" ^ cl#get_name

let name_of_adt_every adt =
  match !output_mode with
    | Pvs_mode -> "every"
    | Isa_mode -> "Every" ^ adt#get_name

let name_of_const_every tc =
  match !output_mode with
    | Pvs_mode -> "Every" ^ tc
    | Isa_mode -> "Every" ^ tc

let name_of_class_rel_every cl =
  match !output_mode with
    | Pvs_mode -> "RelEvery" ^ cl#get_name
    | Isa_mode -> "RelEvery" ^ cl#get_name

let name_of_adt_rel_every adt =
  match !output_mode with
    | Pvs_mode -> "RelEvery"
    | Isa_mode -> "RelEvery" ^ adt#get_name

let name_of_const_rel_every tc =
  match !output_mode with
    | Pvs_mode -> "RelEvery" ^ tc
    | Isa_mode -> "RelEvery" ^ tc

let name_of_adt_map adt =
  match !output_mode with
    | Pvs_mode -> "map"
    | Isa_mode -> adt#get_name ^ "Map"

let name_of_class_map cl =
  match !output_mode with
    | Pvs_mode -> cl#get_name ^ "Map"
    | Isa_mode -> cl#get_name ^ "Map"

let name_of_const_map tc =
  match !output_mode with
    | Pvs_mode -> "Map" ^ tc
    | Isa_mode -> "Map" ^ tc

let name_of_greatest_bisim cl =
  match !output_mode with
    | Pvs_mode -> "bisim?"
    | Isa_mode -> "bibisim"

let name_of_final_coalgebra cl = cl#get_name ^"_c"

let name_of_loose_coalgebra cl = cl#get_name ^"_lc"

let name_of_array_of_primitive s numstring =
  match !output_mode with
    | Pvs_mode ->
	s ^ "?Array(" ^ numstring ^ ")"
    | Isa_mode ->
 	s ^ "'Array";;

let name_of_array_of_class cl numstring =
  match !output_mode with
    | Pvs_mode ->
	cl#get_name ^ "?Array(" ^ numstring ^ ")"
    | Isa_mode ->
	cl#get_name ^ "'Array";;

let name_of_StatResult () =
  match !output_mode with
    | Pvs_mode ->
	"StatResult?"
    | Isa_mode ->
	"StatResult'";;

let name_of_ExprResult () =
  match !output_mode with
    | Pvs_mode ->
	"ExprResult?"
    | Isa_mode ->
	"ExprResult'";;

let name_of_identity_function () = 
  match !output_mode with
    | Pvs_mode ->
	"id"
    | Isa_mode ->
	"id"

(*** Local Variables: ***)
(*** version-control: t ***)
(*** kept-new-versions: 5 ***)
(*** delete-old-versions: t ***)
(*** End: ***)

