(*
 * The LOOP Project
 *
 * The LOOP Team, Dresden University and Nijmegen University
 *
 * Copyright (C) 2002
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License in file COPYING in this or one of the
 * parent directories for more details.
 *
 * Created 14.5.99 by Hendrik
 *
 * Time-stamp: <Monday 8 October 01 17:58:00 tews@ithif51>
 *
 * Lexic for class definitions
 *
 * $Id: top_names.mli,v 1.4 2002/01/23 16:00:24 tews Exp $
 *
 *)

open Top_variant_types

val name_of_pvs_batch : string

val name_of_isa_batch : string

val isabelle_top_theory : string

val name_of_method_functor : <get_name : string; .. > -> string

val name_of_type_of_adt : <get_name : string; .. > -> string

val name_of_self : unit -> string

val name_of_loose_type : <get_name : string; .. > -> string

val name_of_final_type : <get_name : string; .. > -> string

val name_of_class_every : <get_name : string; .. > -> string

val name_of_adt_every : <get_name : string; .. > -> string

val name_of_const_every : string -> string

val name_of_class_rel_every : <get_name : string; .. > -> string

val name_of_adt_rel_every : <get_name : string; .. > -> string

val name_of_const_rel_every : string -> string

val name_of_adt_map : <get_name : string; .. > -> string

val name_of_class_map: <get_name : string; .. > -> string

val name_of_const_map: string -> string

val name_of_greatest_bisim : <get_name : string; .. > -> string

val name_of_type_of_adt : <get_name : string; .. > -> string

val name_of_final_coalgebra: <get_name: string; .. > -> string

val name_of_loose_coalgebra: <get_name: string; .. > -> string

val name_of_array_of_primitive : string -> string -> string

val name_of_array_of_class : <get_name : string; .. > -> string -> string

val name_of_StatResult : unit -> string

val name_of_ExprResult : unit -> string

val name_of_identity_function : unit -> string

(*** Local Variables: ***)
(*** version-control: t ***)
(*** kept-new-versions: 5 ***)
(*** delete-old-versions: t ***)
(*** End: ***)

