;; 
;; The LOOP Project
;; 
;; The LOOP Team, Dresden University and Nijmegen University
;; 
;; Copyright (C) 2002
;; 
;; This program is free software; you can redistribute it and/or
;; modify it under the terms of the GNU General Public License as
;; published by the Free Software Foundation; either version 2 of
;; the License, or (at your option) any later version.
;; 
;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
;; General Public License in file COPYING in this or one of the
;; parent directories for more details.
;; 
;; Created by Hendrik
;; 
;; Time-stamp: <Monday 8 October 01 17:58:00 tews@ithif51>
;; 
;; emacs list script for producing the CCSL grammar
;; without user friendly conversions
;;
;; $Id: compiler.el,v 1.2 2002/01/23 16:00:26 tews Exp $
;; 

(find-file "tmp.buf")
(erase-buffer)
(insert-file-contents "../Ccsl/grammar.mly")
(setq case-fold-search nil)

;; do actions
(replace-regexp "{[^}]*}\\(
;\\)?" "")

(beginning-of-buffer)

(replace-regexp "^[ 	]*
\\([ 	]*|\\)" "\\1")


;; do empty fields
(beginning-of-buffer)
(while (search-forward "/* empty */" nil t)
  (replace-match "(* EMPTY *)" nil t))


(beginning-of-buffer)
(search-forward "End of Token Section")
(beginning-of-line)

;; do comments
(replace-regexp "/\\*[^/]*\\*/" "" nil)
(beginning-of-buffer)

;; do hot things
(search-forward-regexp "^%%" (point-max) t 2)
(setq diff (- (point-max) (point)))
(goto-char (point-min))

;;make things hot
(search-forward-regexp "^%%")
(forward-line)
(while (re-search-forward " \\([a-z_]*\\)" (- (point-max) diff) t 1)
  (replace-match " <a href=\"#\\1\">\\1</a>"))
(goto-char (point-min))

;; mark positions
(search-forward-regexp "^%%")
(forward-line)
(while (re-search-forward "^\\(\\([a-z_]+\\):\\)" (- (point-max) diff) t 1)
  (replace-match "<a name=\"\\2\">\n\\1"))
(goto-char (point-min))
;(save-buffer)

(let* ((start (save-excursion
	       (search-forward "Token Section")
	       (beginning-of-line)
	       (next-line 3)
	       (point)))
      (end (save-excursion
	     (search-forward "End of Token Section")
	     (beginning-of-line)
	     (previous-line 2)
	     (indent-rigidly start (point) 8)
	     (point))))
  (copy-to-register ?A start end))

(beginning-of-buffer)

(let* ((start (progn (search-forward-regexp "^%%")
		   (beginning-of-line)
		   (next-line 2)
		   (point)))
      (end  (progn (search-forward-regexp "^%%")
		   (beginning-of-line)
		   (indent-rigidly start (point) 8)
		   (point))))
  (copy-to-register ?B start end))

(kill-buffer (current-buffer))

( setq load-path (append
		  (list (expand-file-name "~tews/lib/lisp/Fsf-20.5" ))
		  load-path))

(autoload 'html-helper-mode "html-helper-mode" "Yay HTML" t)
(setq auto-mode-alist (cons '("\\.html$" . html-helper-mode) auto-mode-alist))

;(add-hook 'tempo-insert-string-functions 'upcase)
(setq html-helper-address-string 
  "by <a href=\"/~tews\">Hendrik</a>")

;; "Thu Jun 26 18:03:02 1997"

(defun my-html-timestamp ()
  "My timestamp insertion function."
  (let ((time (current-time-string)))
    (insert (substring time 8 11)
	    (substring time 4 8)
	    (substring time 20 24)
	    "\n")))

(setq html-helper-timestamp-hook 'my-html-timestamp)

(setq vc-handle-cvs nil)

(find-file "compiler.html")
(erase-buffer)
(insert-file-contents "skeleton.html")
(beginning-of-buffer)

(search-forward "<pre>")
(beginning-of-line)
(next-line 1)
(insert-register ?B)

(search-forward "<pre>")
(beginning-of-line)
(next-line 1)
(insert-register ?A)

(save-buffer)