(*
 * The LOOP Project
 *
 * The LOOP Team, Dresden University and Nijmegen University
 *
 * Copyright (C) 2002
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License in file COPYING in this or one of the
 * parent directories for more details.
 *
 * Created 14.5.99 by Hendrik
 *
 * Time-stamp: <Tuesday 21 May 02 14:18:08 tews@ithif51>
 *
 * adding components
 *
 * $Id: component_pass.ml,v 1.5 2002/05/22 13:42:39 tews Exp $
 *
 *)

open Util
open Top_variant_types
open Types_util
;;


(***********************************************************************
 ***********************************************************************
 *
 * Member wise units
 *
 *)

    (*******************************************************************
     *
     * ADT's
     *)

let do_adt_member_component adt v typ =
  let is_not_adt,ciface,args = match typ with
    | Class(cl,args) -> true,cl,args
    | Adt(adt,_,args) -> false,adt,args
    | Groundtype(id,args) -> 
	(match id.id_origin with
	   | CCSL_GroundTypeDecl si -> true,si,args
	   | CCSL_GroundTypeDef  si -> true,si,args
	   | _ -> assert(false)
	)
    | _ -> assert(false)
  in
  let carrier_args = lazy (count_carrier_args args <> 0) in
  let const_args = lazy (constant_arg_list (fun x -> true) args)
  in
    if not (Lazy.force const_args) 
    then
      begin
	if is_not_adt then
	  begin
	    adt#put_feature ClassComponentFeature;
	    if Lazy.force carrier_args
	    then
	      adt#put_feature CarrierClassComponentFeature
	  end;
	if not (type_has_feature HasRelLiftFeature typ)
	then
	  adt#put_feature ComponentNoFullRelLiftFeature;
	if not (type_has_feature HasMapFeature typ)
	then
	  adt#put_feature ComponentNoFullMapFeature
      end;
    adt#add_component (v,ciface,args)


let do_adt_member adt m =
  match m#get_sort with
    | Adt_Const_Constructor | Adt_Reduce -> ()
    | Class_Coreduce | Class_Special -> assert(false)
    | _ -> 
	begin
	  iter_components Pos (do_adt_member_component adt) m#get_domain;
	end



    (*******************************************************************
     *
     * Classes
     *)

let do_ancestor iface oanc args =
  iter_component_arglist_add_component iface args oanc#get_parameters


let do_class_member_component cl v typ =
  let ciface,args = match typ with
    | Class(cl,args) -> cl,args
    | Adt(adt,_,args) -> adt,args
    | Groundtype(id,args) -> 
	(match id.id_origin with
	   | CCSL_GroundTypeDecl si -> si,args
	   | CCSL_GroundTypeDef  si -> si,args
	   | _ -> assert(false)
	)
    | _ -> assert(false)
  in
  let self_args = lazy (count_self_args args <> 0) in
  let const_args = lazy (constant_arg_list (fun x -> true) args)
  in
    (if (not (type_has_feature HasRelLiftFeature typ)) 
     then
       if Lazy.force self_args
       then
	 begin
	   cl#put_feature ComponentNoRelLiftFeature;
	   cl#put_feature ComponentNoFullRelLiftFeature
	 end
       else 
	 if not (Lazy.force const_args)
	 then
	   cl#put_feature ComponentNoFullRelLiftFeature
    );

    (if (not (type_has_feature HasMapFeature typ)) then
       if Lazy.force self_args 
       then
	 cl#put_feature ComponentNoMapFeature
       else
	 if not (Lazy.force const_args)
	 then
	   cl#put_feature ComponentNoFullMapFeature
    );

    cl#add_component (v,ciface,args)

      
let do_class_member cl m =
(* 					(* debugging support *) 
  let name : string = m#get_name
  in
*)
  match m#get_sort with
    | Class_Coreduce | Class_Special -> ()
    | Adt_Const_Constructor | Adt_Reduce -> assert(false)
    | _ -> 
	begin
	  iter_components Neg (do_class_member_component cl) m#get_domain;
	  iter_components Pos (do_class_member_component cl) m#get_codomain
	end


    (*******************************************************************
     *
     * Groundsigs
     *)


let do_typedef si idrec = match idrec.id_origin with
  | CCSL_GroundTypeDef _ ->
      iter_components_add_component si idrec.id_type
  | CCSL_GroundTypeDecl _ -> ()
  | _ -> assert(false)



(***********************************************************************
 ***********************************************************************
 *
 * top level units
 *
 *)

let class_component_pass cl = 
  (* we are after inheritance pass and after invariance pass *)
  List.iter 
    (function
       | Resolved_renaming(oanc,args,_,_,_) -> do_ancestor cl oanc args
       | _ -> assert(false)
    )
    cl#get_ancestors;
  List.iter (do_class_member cl) cl#get_all_members


let adt_component_pass adt = 
  (* we are after inheritance pass and after invariance pass *)
  List.iter (do_adt_member adt) adt#get_members


let sig_component_pass si = 
  List.iter (do_typedef si) si#get_all_ground_types



(* Called from the feature pass
 * 
 * let component_ast = function
 *   | CCSL_class_dec cl -> do_iface cl
 *   | CCSL_adt_dec adt -> do_iface adt
 *   | CCSL_sig_dec si -> ()
 *   | CCSL_TypeAbbrev_dec ta -> ()
 * 
 * 
 * let ccsl_component_pass (ast: Classtypes.ccsl_ast list) = 
 *   List.iter component_ast ast
 * 
 *)


(*** Local Variables: ***)
(*** version-control: t ***)
(*** kept-new-versions: 5 ***)
(*** delete-old-versions: t ***)
(*** time-stamp-line-limit: 30 ***)
(*** End: ***)

