(*
 * The LOOP Project
 *
 * The LOOP Team, Dresden University and Nijmegen University
 *
 * Copyright (C) 2002
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License in file COPYING in this or one of the
 * parent directories for more details.
 *
 * Created 14.5.99 by Hendrik
 *
 * Time-stamp: <Wednesday 22 May 02 18:23:45 tews@ithif51>
 *
 * strings for ccsl translation
 *
 * $Id: names.ml,v 1.10 2002/05/30 13:10:30 tews Exp $
 *
 *)

open Global
open Top_variant_types;;


let anon_sig_prefix = "AnonymousSignature_" 


(*******************************************************************
 *
 * theory names
 *)
  
let ccsl_interface_theory_name cl = cl#get_name ^ "Interface"

let ccsl_lift_theory_name cl = cl#get_name ^ "PredicateLifting"

let ccsl_method_idtype_adt_name cl = cl#get_name ^ "_Method_Id"
				 
let ccsl_method_lift_theory_name cl = cl#get_name ^ "MethodPredicateLifting"
				 
let ccsl_private_invariance_rewrite_name cl = cl#get_name ^ "InvariantRewrite"

let ccsl_public_invariance_rewrite_name cl = 
  cl#get_name ^ "PublicInvariantRewrite"

let ccsl_method_invariance_rewrite_name cl =
	cl#get_name ^ "MethodInvariantRewrite"
		
let ccsl_method_invariance_inherit_name cl =
	cl#get_name ^ "MethodInvariantInherit"
		
let ccsl_box_theory_name cl =
  cl#get_name ^ "Box"

let ccsl_box_inherit_theory_name cl =
  cl#get_name ^ "BoxInherit"

let ccsl_step_theory_name cl =
  cl#get_name ^ "Step"

let ccsl_path_theory_name cl =
  cl#get_name ^ "Paths"
    
let ccsl_bibisim_theory_name cl =
  cl#get_name ^ "Bisimilarity"

let ccsl_private_bibisim_rewrite_theory_name cl = 
  cl#get_name ^ "BisimilarityRewrite"

let ccsl_public_bibisim_rewrite_theory_name cl = 
  cl#get_name ^ "PublicBisimilarityRewrite"

let ccsl_bisim_eq_theory_name cl =
  cl#get_name ^ "BisimilarityEquivalence"

let ccsl_private_bisim_eq_rewrite_theory_name cl = 
  cl#get_name ^ "BisimilarityEqRewrite"

let ccsl_public_bisim_eq_rewrite_theory_name cl = 
  cl#get_name ^ "PublicBisimilarityEqRewrite"

let ccsl_req_bisim_theory_name cl =
  cl#get_name ^ "ReqObsEq"

let ccsl_definitions_theory_name cl =
  cl#get_name ^ "Definitions"

let ccsl_morphism_theory_name cl =
  cl#get_name ^ "Morphism"

let ccsl_morphism_rewrite_theory_name cl =
  cl#get_name ^"MorphismRewrite"

let ccsl_finality_theory_name cl =
  cl#get_name ^"Finality"

let ccsl_map_struct_theory_name cl =
  cl#get_name ^"MapStruct"

let ccsl_map_theory_name cl =
  cl#get_name ^"Map"

let ccsl_semantics_theory_name cl =
  cl#get_name ^ "Semantics"

let ccsl_basic_theory_name cl =
  cl#get_name ^ "Basic"

let ccsl_coadt_theory_name cl = cl#get_name

let ccsl_loose_theory_name cl = cl#get_name ^ "Loose"

let ccsl_final_theory_name cl = cl#get_name ^ "Final"

let ccsl_final_props_theory_name cl = cl#get_name ^ "FinalProp"

let ccsl_full_invariant_theory_name cl = cl#get_name ^ "FullInvariant"

let ccsl_greatest_invariance_theory_name cl =
  ccsl_full_invariant_theory_name cl

let ccsl_map_theory_name cl = cl#get_name ^ "Map"

let ccsl_full_bibisim_theory_name cl = cl#get_name ^ "FullBisimulation"

let ccsl_greatest_bibisim_theory_name cl = 
  ccsl_full_bibisim_theory_name cl

let ccsl_theorem_theory_name cl =
  cl#get_name ^ "Theorem"


let ccsl_adt_theory_name adt = adt#get_name 

let ccsl_adtutil_theory_name adt = adt#get_name ^ "Util"

let ccsl_adt_every_theory_name adt = adt#get_name ^ "Every"

let ccsl_adt_rellift_theory_name adt = adt#get_name ^ "RelLift"

let ccsl_adt_map_theory_name adt = adt#get_name ^ "Map"

let ccsl_sig_def_theory_name adt = adt#get_name ^ "Definitions"

(* the next two are hardwired in the prelude *)

let ccsl_empty_type_defn_theory_name = "EmptyTypeDef"

let ccsl_empty_fun_theory_name = "EmptyFun"

let ccsl_prelude_name = "ccsl_prelude"

(*******************************************************************
 *
 * item names
 *)

(* the next two are hardwired in the prelude *)

let name_of_empty_type = "EmptyType"

let name_of_empty_fun = "empty_fun"

let name_of_unique_empty_fun_lemma = "unique_empty_fun"

let name_of_self = "Self"

let name_of_coalgebra = "c"

let name_of_algebra_final cl =
  cl#get_name ^ "_z"

let name_of_algebra_loose cl =
  cl#get_name ^ "_lz"

let name_of_coalgebra1 = "c1"

let name_of_coalgebra2 = "c2"

let name_of_algebra = "z"

let name_of_method_id = "m"

let name_of_constructor_functor cl = cl#get_name ^ "Constructors"

let super_label cl = 
  match !output_mode with
    | Pvs_mode -> "super_" ^ cl#get_name 
    | Isa_mode -> "super_" ^ cl#get_name


let super_access_method cl = "super_" ^ cl#get_name 

let method_label m = 
  match !output_mode with
    | Pvs_mode -> m#get_name
    | Isa_mode -> m#get_name


let name_of_struct_of cl =
  match !output_mode with
    | Pvs_mode -> cl#get_name ^ "_struct"
    | Isa_mode -> cl#get_name ^ "_struct"
  

let name_of_method_tag_string name = 
  match !output_mode with
    | Pvs_mode -> name
    | Isa_mode -> name ^ "_tag"

let name_of_method_tag m = name_of_method_tag_string m#get_name

let name_of_method_tag_recognizer m = 
  match !output_mode with
    | Pvs_mode -> (name_of_method_tag m) ^ "?"
    | Isa_mode -> "is_" ^ (name_of_method_tag m)


let constructor_accessor_name c = c ^ "_acc"

let constructor_recognizer c =
  match !output_mode with
    | Pvs_mode -> c#get_name ^ "?"
    | Isa_mode -> "is_" ^ c#get_name

let update_method_name a = "set_" ^ a#get_name

let name_of_independent_assertion a u = a#get_name ^ "_" ^ u#get_name

let name_of_update_assertion a u = a#get_name ^ "_" ^ u#get_name

let name_of_loose_coalg_axiom = "loose_coalgebra"

let name_of_loose_alg_axiom = "loose_constructors"

let name_of_final_coalg_axiom = "final_coalgebra"

let name_of_final_prop_axiom = "final_prop"

let name_of_final_alg_axiom = "final_constructors"

let name_of_full_class_pred cl = cl#get_name ^ "FullPred"

let name_of_full_public_class_pred cl = cl#get_name ^ "FullPublicPred"

let name_of_public_class_pred cl = "Public_" ^ cl#get_name ^ "_Pred"

let name_of_method_class_pred cl = cl#get_name ^ "_MethodPred"

let name_of_private_class_rel cl = cl#get_name ^ "_Rel"

let name_of_public_class_rel cl = "Public_" ^ cl#get_name ^ "_Rel"

let name_of_full_class_rel cl = cl#get_name ^ "_FullRel"

let name_of_full_public_class_rel cl = "Public_" ^ cl#get_name ^ "_FullRel"

let name_of_class_map_struct cl = cl#get_name ^ "_map_struct"

let name_of_admissable_map_fun_pred cl = cl#get_name ^ "_admissable_funs"


let name_of_equivalence = "equivalence?"

let lifting_name_prefix = "ObsEq_"

let name_of_private_bibisimulation cl = 
  match !output_mode with
    | Pvs_mode -> "bisimulation?"
    | Isa_mode -> "bibisimulation"

let name_of_private_struct_bibisimulation cl = 
  match !output_mode with
    | Pvs_mode -> cl#get_name ^ "_class_bisimulation?"
    | Isa_mode -> cl#get_name ^ "_class_bibisimulation"

let name_of_public_bibisimulation cl = 
  match !output_mode with
    | Pvs_mode -> "public_bisimulation?"
    | Isa_mode -> "public_bibisimulation"

let name_of_private_bibisim cl = 
  Top_names.name_of_greatest_bisim cl

let name_of_public_bibisim cl = 
  match !output_mode with
    | Pvs_mode -> "public_bisim?"
    | Isa_mode -> "public_bibisim"

let name_of_private_bisimulation_eq cl = 
  match !output_mode with
    | Pvs_mode -> "bisimulation?"
    | Isa_mode -> "bisimulation"

let name_of_public_bisimulation_eq cl =
  match !output_mode with
    | Pvs_mode -> "public_bisimulation?"
    | Isa_mode -> "public_bisimulation"

let name_of_private_bisim_eq cl =
  match !output_mode with
    | Pvs_mode -> "bisim?"
    | Isa_mode -> "bisim"

let name_of_public_bisim_eq cl =
  match !output_mode with
    | Pvs_mode -> "public_bisim?"
    | Isa_mode -> "public_bisim"

let name_of_full_bibisimulation cl =
  match !output_mode with
    | Pvs_mode -> "full_bisimulation?"
    | Isa_mode -> cl#get_name ^ "_full_bisim"

let name_of_loose_private_bisim_eq cl =
  name_of_private_bibisim cl

let name_of_loose_public_bisim_eq cl =
  name_of_public_bibisim cl

let dummy_variable = "z"

let name_of_full_invariance cl = 
  match !output_mode with
    | Pvs_mode -> "fullinvariant?"
    | Isa_mode -> cl#get_name ^ "_fullinvariant"

let name_of_private_invariance cl = 
  match !output_mode with
    | Pvs_mode -> "invariant?"
    | Isa_mode -> cl#get_name ^ "_invariant"

let name_of_private_struct_invariance cl = 
  match !output_mode with
    | Pvs_mode -> cl#get_name ^ "_class_invariant?"
    | Isa_mode -> cl#get_name ^ "_class_invariant"


let name_of_public_invariance cl = 
  match !output_mode with
    | Pvs_mode -> "public_invariant?"
    | Isa_mode -> "public_invariant"

let name_of_method_invariance cl =
  match !output_mode with
		| Pvs_mode -> "method_invariant?"
		| Isa_mode -> "method_invariant"

let name_of_greatest_invariance cl =
  match !output_mode with
		| Pvs_mode -> "greatest_inv?"
		| Isa_mode -> "greatest_inv"

let name_of_h_gi = "H_gi"

let name_of_box = "box"

let name_of_diamond = "diamond"

let name_of_monotonic = 
  match !output_mode with
    | Pvs_mode -> "monotonic?"
    | Isa_mode -> "monotonic"

let name_of_nonempty =
  match !output_mode with
    | Pvs_mode -> "nonempty?"
    | Isa_mode -> "nonempty"
 
let name_of_gfp = "gfp"

let name_of_admissible =
  match !output_mode with
    | Pvs_mode -> "admissible?"
    | Isa_mode -> "admissible"  

let name_of_admissible_null_lemma = "admissible_null"

let name_of_admissible_linear_lemma = "admissible_linear"

let name_of_admissible_append_lemma = "admissible_append"

let name_of_transition = "transition"

let name_of_transition_append_lemma = "transition_append"

let name_of_transition_at_end_lemma = "transition_at_end"

let name_of_invariant_char_lemma = "invariant_char"

let name_of_diamond_transition_lemma = "diamond_transition"

let name_of_transition_diamond_lemma = "transition_diamond"

let name_of_initially cl = 
  match !output_mode with
    | Pvs_mode -> "initially?"
    | Isa_mode -> "initially"

(* Use name_of_list_member always with SmartApplication, 
 * because in Isabelle it is curried!!
 *)
let name_of_list_member () = 
  match !output_mode with
    | Pvs_mode -> "member"
			(* mem is an infix operator in isabelle  *)
    | Isa_mode -> "(op mem)"

let name_of_choose () =
  match !output_mode with
    | Pvs_mode -> "choose"
    | Isa_mode -> "choose"

let name_of_assertion_predicate ass = 
  match !output_mode with
    | Pvs_mode -> ass ^ "?"
    | Isa_mode -> ass ^ "_pred"

let name_of_assertion_lemma ass = ass

let name_of_inherited_assert_lemma cl =
  "Super" ^ cl#get_name ^ "Assert"

let name_of_creation_predicate = name_of_assertion_predicate

let name_of_creation_lemma crea = crea

let name_of_assert cl = 
  match !output_mode with
    | Pvs_mode -> cl#get_name ^ "Assert?"
    | Isa_mode -> cl#get_name ^ "Assert"

let name_of_method_assert cl = 
  match !output_mode with
    | Pvs_mode -> cl#get_name ^ "MethodAssert?"
    | Isa_mode -> cl#get_name ^ "MethodAssert"

let name_of_creation cl = 
  match !output_mode with
    | Pvs_mode -> cl#get_name ^ "Create?"
    | Isa_mode -> cl#get_name ^ "Create"

let name_of_model cl = 
  match !output_mode with
    | Pvs_mode -> cl#get_name ^ "Model?"
    | Isa_mode -> cl#get_name ^ "Model"

let name_of_graph = "graph"

let name_of_gfp = "gfp"

(*******************************************************************
 *
 * Invariance Type names
 *)
					
let name_of_method_enum_type cl = ccsl_method_idtype_adt_name cl

let name_of_complete_inv_id_list cl = 
  match !output_mode with
    | Pvs_mode -> "complete_" ^ cl#get_name ^ "_inv_list?"
    | Isa_mode -> "complete_" ^ cl#get_name ^ "_inv_list"

let name_of_method_pred_type cl = cl#get_name ^ "_Method_PredType"


(*******************************************************************
 *
 * Invariance Predicate names
 *)


let name_of_method_predicate m = m#get_name ^ "_Pred"


(*******************************************************************
 *
 * lemma names
 *)

let name_of_inv_true_lemma = "inv_true"

let name_of_inv_and_lemma = "inv_and"

let name_of_inv_list_lemma = "inv_list"

let name_of_inv_lemma m = "inv_" ^ m#get_name

let name_of_private_bibisim_lemma m = "bibisim_" ^ m #get_name

let name_of_public_bibisim_lemma m = "public_bibisim_" ^ m #get_name

let name_of_private_bisim_eq_lemma m = "bisim_" ^ m #get_name

let name_of_public_bisim_eq_lemma m = "public_bisim_" ^ m #get_name

let name_of_private_bisim_bisim_lemma = "bisim_bisim"

let name_of_public_bisim_bisim_lemma = "public_bisim_bisim"

let name_of_private_eq_bisim_lemma = "eq_bisim"

let name_of_public_eq_bisim_lemma = "public_eq_bisim"

let name_of_private_bisim_refl_lemma = "bisim_refl"

let name_of_public_bisim_refl_lemma = "public_bisim_refl"

let name_of_private_bisim_sym_lemma = "bisim_sym"

let name_of_public_bisim_sym_lemma = "public_bisim_sym"

let name_of_private_bisim_trans_lemma = "bisim_trans"

let name_of_public_bisim_trans_lemma = "public_bisim_trans"

let name_of_private_bisim_equiv_lemma = "bisim_equiv"

let name_of_public_bisim_equiv_lemma = "public_bisim_equiv"


let name_of_inv_linear_cons_lemma = "inv_linear_cons"

let name_of_inv_linear_append_lemma = "inv_linear_append"

(* 
 * names for greatest invariant lemmas
 * 
 *)

let name_of_gfp_bound_lemma = "gfp_bound"

let name_of_greatest_inv_unique_lemma = "greatest_inv_unique"

let name_of_h_gi_monotonic_lemma = "H_gi_monotonic"

let name_of_greatest_inv_char_lemma = "greatest_inv_char"

let name_of_greatest_inv_exist_lemma = "greatest_inv_exist"

(* 
 * 
 * names for box lemmas
 *)
let name_of_box_K_lemma cl = cl#get_name ^"_box_monotone"

let name_of_box_T_lemma cl = cl#get_name ^"_box_T"

let name_of_diamond_T_lemma cl = cl#get_name ^"_diamond_T"

let name_of_box_4_lemma cl = cl#get_name ^"_box_4"
			
let name_of_diamond_4_lemma cl = cl#get_name ^"_diamond_4"
			
let name_of_box_linear_cons_lemma cl = cl#get_name ^ "_box_linear_cons"

let name_of_box_linear_append_lemma cl = cl#get_name ^ "_box_linear_append"

let name_of_inv_inherit_lemma acl = "inherit_inv_" ^ acl#get_name

let name_of_box_inv_lemma cl = cl#get_name ^ "_box_inv"

let name_of_diamond_inv_lemma cl = cl#get_name ^ "_diamond_onestep"

let name_of_box_greatest_inv_lemma cl = cl#get_name ^ "_box_greatest"

let name_of_box_inherit_lemma acl = "inherit_box_" ^ acl#get_name

(*******************************************************************
 *
 * Morphism Predicate names
 *)


let name_of_full_morphism_pred cl =
  match !output_mode with
    | Pvs_mode -> cl#get_name ^ "morphism?"
    | Isa_mode -> cl#get_name ^ "morphism"

let name_of_full_morphism_struct_pred cl =
  match !output_mode with
    | Pvs_mode -> cl#get_name ^ "_class_morphism?"
    | Isa_mode -> cl#get_name ^ "_class_morphism"

let name_of_public_morphism_pred cl =
  match !output_mode with
    | Pvs_mode -> cl#get_name ^ "public_morphism?"
    | Isa_mode -> cl#get_name ^ "public_morphism"

(*******************************************************************
 *
 * Morphism Lemma names
 *)

let name_of_morphism_bisim_lemma cl =
  cl#get_name ^ "_bisimulation_morphism"

let name_of_method_morphism_lemma m =
  m#get_name ^ "_morphism"

(*******************************************************************
 *
 * Finality names
 *)

let name_of_finality_existence cl =
  match !output_mode with
    | Pvs_mode -> cl#get_name ^ "_morphism_exists?"
    | Isa_mode -> cl#get_name ^ "_morphism_exists"

let name_of_finality_uniqueness cl =
  match !output_mode with
    | Pvs_mode -> cl#get_name ^ "_morphism_unique?"
    | Isa_mode -> cl#get_name ^ "_morphism_unique"

let name_of_finality cl =
  match !output_mode with
    | Pvs_mode -> cl#get_name ^ "_final?"
    | Isa_mode -> cl#get_name ^ "_final"

    (* reduce is hardcoded in method inv_list_proof in the invariant theory *)
let name_of_adt_reduce adt =
  match !output_mode with
    | Pvs_mode -> "reduce"
    | Isa_mode -> "reduce_" ^ adt#get_name

let name_of_class_coreduce cl =
  match !output_mode with
    | Pvs_mode -> "coreduce"
    | Isa_mode -> "coreduce_" ^ cl#get_name

let name_of_class_struct_coreduce cl =
  match !output_mode with
    | Pvs_mode -> "struct_coreduce"
    | Isa_mode -> "struct_coreduce_" ^ cl#get_name

let name_of_finality_bisim_eq_lemma cl =
  cl#get_name ^ "_finality_bisim_eq"

(*******************************************************************
 *
 * file names
 *)

let ccsl_class_file_name cl = cl#get_name ^ "_basic"

let ccsl_class_theorem_file_name cl = cl#get_name ^ "_theorem"

let ccsl_box_file_name cl = cl#get_name ^ "_basic"

let ccsl_adt_file_name adt = adt#get_name ^ "_basic"

let ccsl_sig_file_name si = si#get_name ^ "_basic"

let name_of_pvs_ccsl_lib = "ccsllib"

let name_of_fixedpoints = "fixedpoints"

(*** Local Variables: ***)
(*** version-control: t ***)
(*** kept-new-versions: 5 ***)
(*** delete-old-versions: t ***)
(*** time-stamp-line-limit: 30 ***)
(*** End: ***)

