/*
 * The LOOP Project
 *
 * The LOOP Team, Dresden University and Nijmegen University
 *
 * Copyright (C) 2002
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License in file COPYING in this or one of the
 * parent directories for more details.
 *
 * Adopted 25.1.99 by Hendrik
 *
 * Time-stamp: <Monday 8 October 01 17:58:00 tews@ithif51>
 *
 * Grammar for yacc declaration sections
 *
 * $Id: yacc_grammar.mly,v 1.4 2002/05/03 15:01:21 tews Exp $
 *
 */

%{
  let d s =
    if !Global.debug
    then  begin
      prerr_string( "Reduce " ^ s ^ "\n" );
      flush stderr
    end;;
%}

%token TOKEN	/* KEYWORD [...] */
%token START
%token TYPE
%token LEFT
%token RIGHT
%token ASSOC
%token EOD
%token HEADER
%token <string> TYPEDEC
%token CONFIG
%token KEYWORD
%token COMMENT
%token <string> SYMBOL

%start tokens

%type <(string * string option) list> tokens
%type <unit> optional_header
%type <(string * string option ) list> declarationlist
%type <(string * string option) option> declaration
%type <unit> symbollist

%%

tokens:
    optional_header declarationlist EOD	{ d "tokens";
					  List.rev $2 }
;

optional_header:
    HEADER				{ d "optheader 1"; () }
  |					{ d "optheader 2"; () }
;

declarationlist:
    declarationlist declaration		{ d "decl list";
					  match $2 with
					    | None -> $1
					    | Some d -> d :: $1
					}
  |					{ d " decl list empty"; [] }
;

declaration:
    TOKEN typeopt SYMBOL			{ d "decl 1"; None }
/*									*/
/*  %to.. token  /* KE.. mode   repr   case				*/
/*									*/
  | TOKEN typeopt SYMBOL KEYWORD		{ d "decl 2"; Some($3,$2) }

/* no modes any more
  | TOKEN SYMBOL KEYWORD SYMBOL		{ Some($2, Some $4, None   , None   ) }
  | TOKEN SYMBOL KEYWORD SYMBOL SYMBOL	{ Some($2, Some $4, Some $5, None   ) }
  | TOKEN SYMBOL KEYWORD SYMBOL SYMBOL SYMBOL
					{ Some($2, Some $4, Some $5, Some $6) }
*/
/*									*/
/*									*/
/*									*/
  | START symbollist_maybe		{ d "start"; None }
  | TYPE  TYPEDEC symbollist_maybe	{ d "type"; None }
  | LEFT  SYMBOL			{ d "left"; None }
  | LEFT  SYMBOL  symbollist		{ d "left 2"; None }
  | RIGHT  SYMBOL			{ d "right 1"; None }
  | RIGHT  SYMBOL  symbollist		{ d "right 2"; None }
  | ASSOC symbollist_maybe		{ d "assoc"; None }
;

typeopt:
  | /* EMPTY */                         { d "emptytyp"; None }
  | TYPEDEC                             { d "typeopt"; Some $1 }
;

symbollist_maybe:
    symbollist_maybe SYMBOL		{ d "optsymlist"; () }
  |					{ d "optsymlist empty"; () }
;

symbollist:  
    SYMBOL				{ d "symlist fst"; ()}
  | symbollist SYMBOL			{ d "symlist next"; ()}


/*** Local Variables: ***/
/*** version-control: t ***/
/*** kept-new-versions: 5 ***/
/*** delete-old-versions: t ***/
/*** time-stamp-line-limit: 30 ***/
/*** End: ***/




