(*
 * The LOOP Project
 *
 * The LOOP Team, Dresden University and Nijmegen University
 *
 * Copyright (C) 2002
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License in file COPYING in this or one of the
 * parent directories for more details.
 *
 * Created 14.5.99 by Hendrik
 *
 * Time-stamp: <Wednesday 17 July 02 17:28:48 tews@ithif51>
 *
 * theory for theorems
 *
 * $Id: class_theorems_theory.ml,v 1.4 2002/07/18 13:43:21 tews Exp $
 *
 *)


open Util
open Global
open Top_variant_types
open Classtypes
open Theory_class 
open Name_space 
open Names
open Pre_printing
open Types_util
;;


(***********************************************************************
 ***********************************************************************
 *
 * Isar theorem delimiters
 *
 *)

class ccsl_isar_start_theorems cl =
  let imports = remove_duplicates (=)
		  ( 
		    (isar_theory_name cl) ::
		    (List.map fst cl#get_theorem_imports) 
		  )
  in
    [ccsl_iface_type, ccsl_member_type] 
    ccsl_pre_isabelle_delimiter_theory_class
      cl
      eq_ccsl_types
      IsabelleStartFile
      (ccsl_class_theorem_file_name cl)
      imports


class ccsl_isar_close_theorems cl =
  [ccsl_iface_type, ccsl_member_type] 
  ccsl_pre_isabelle_delimiter_theory_class
    cl
    eq_ccsl_types
    IsabelleCloseFile
    (ccsl_class_theorem_file_name cl)
    []



(***********************************************************************
 ***********************************************************************
 *
 * theorems theory
 *
 *)

class ['class_type, 'member_type] ccsl_pre_class_theorem_theory 
  (cl : 'class_type) 
  (* the equality relation for initializing the name space *)
  (eq_types : ('class_type, 'member_type) top_pre_types
     -> ('class_type, 'member_type) top_pre_types -> bool)

  : ['class_type, 'member_type] ccsl_pre_class_theory_type =
  object (self : 'self)

    inherit 
      ['class_type, 'member_type] ccsl_pre_class_theory_class cl eq_types
      as top_theory

       (* reserve all names, that we want to declare *)
    initializer reserve ns []
           
    method get_name = ccsl_theorem_theory_name cl

    method get_parameters = self#simple_parameters 

      (* Override this method, if proofs should not be written *)
    method do_proofs = false

    initializer top_theory#override_file_name (ccsl_class_theorem_file_name cl)

    method private imports =
      Import(
	(ccsl_basic_theory_name cl, self#simple_arguments)
	:: cl#get_theorem_imports
      )

    method private do_theorems =
      let decl_from_rec id = 
	id.id_token.token_name, id.id_type  
      in
	List.map
	  (fun thm ->
	     Lemma(
	       thm.assertion_name.token_name,
	     
	       match thm.assertion_formula with
(* HENDRIK: this is only a temporary fix, decide on let trick *)
		 | Pvs_String f -> 
		     assert(!output_mode = Pvs_mode); 
		     Forall(
		       (name_of_coalgebra, self#coalgebra_type) ::
		       (List.map decl_from_rec thm.free_variables),
		       Implies(
			 self#assert_coalgebra_hypothesis,
			 ConstantPredicate(f)))
		 | Isa_String f -> 
		     assert(!output_mode = Isa_mode); 
		     Forall(
		       (name_of_coalgebra, self#coalgebra_type) ::
		       (List.map decl_from_rec thm.free_variables),
		       Implies(
			 self#assert_coalgebra_hypothesis,
			 ConstantPredicate(f)))
		 | Symbolic f -> 
		     let pre_pretty_ass = 
		       ccsl_pre_pretty_formula cl 
			 self#get_member_fun self#get_iface_fun
			 f
		     in 
		       (* For PVS snip the first forall off the assertion 
			  and merge it with the quantifier for the coalgebra
		       *)
		     let (all_decl, all_body) = match pre_pretty_ass with
		       | Forall(decllist, body) -> (decllist, body)
		       | x -> ([], x)
		     in
		       match !output_mode with
			 | Pvs_mode -> 
			     Forall(
			       (name_of_coalgebra, self#coalgebra_type) ::
			       (List.map decl_from_rec thm.free_variables)
			       @ all_decl,
			       Implies(
				 self#assert_coalgebra_hypothesis,
				 all_body))
			 | Isa_mode -> 
			     MetaImplies(
			       self#assert_coalgebra_hypothesis,
			       pre_pretty_ass)
	     ))
	  cl#get_theorems

    method make_body =
      [
	self#imports;
      ]
      @
      self#do_theorems

(* ISAR
 *     method get_proofs = []
 *)
end

class ccsl_class_theorem_theory cl = 
  [ccsl_iface_type, ccsl_member_type] 
  ccsl_pre_class_theorem_theory cl eq_ccsl_types





(*** Local Variables: ***)
(*** version-control: t ***)
(*** kept-new-versions: 5 ***)
(*** delete-old-versions: t ***)
(*** time-stamp-line-limit: 30 ***)
(*** End: ***)

