(*
 * The LOOP Project
 *
 * The LOOP Team, Dresden University and Nijmegen University
 *
 * Copyright (C) 2002
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License in file COPYING in this or one of the
 * parent directories for more details.
 *
 * Created 15.1.99 by Hendrik
 *
 * Time-stamp: <Monday 11 March 02 11:33:10 tews@ithif51>
 *
 * Utility functions
 *
 * $Id: util.mli,v 1.4 2002/05/03 15:01:20 tews Exp $
 *
 *)


(*******************************************************************
 *******************************************************************
 *
 * Exceptions
 *)


(*******************************************************************
 *
 * for internal invariants: if a match has a case which should never 
 * occur and if it is not possible to define the match using less 
 * Variants I suggest to insert a line
 *   begin assert(false) end
 * 
 *)
exception Internal_error


(*******************************************************************
 *
 * Support for growing implementation
 *)
exception To_be_implemented of string


(* exception thrown by find_member and find_local_member,
 * if a member is not found
 *)
exception Member_not_found


(*******************************************************************
 *******************************************************************
 *
 * List utility functions
 *)

  (* upto 5 = [ 0; 1; 2; 3; 4 ] *)
val upto : int -> int list

val last : 'a list -> 'a

val but_last : 'a list -> 'a list

val member : ('a -> 'a -> bool) -> 'a -> 'a list -> bool 

val assoc : ('a -> 'a -> bool) -> 'a -> ('a * 'b) list -> 'b

val remove_duplicates : ('a -> 'a -> bool) -> 'a list -> 'a list 

val option_filter : 'a option list -> 'a list

   (* take l n returns the sublist of l, containing the first n 
    * elements of l 
    *)
val take : 'a list -> int -> 'a list

   (* tail l n returns l without the first n elements 
    *)
val tail : 'a list -> int -> 'a list

   (* three fold version of List.map3 *)
val map3 : ('a -> 'b -> 'c -> 'd) -> 'a list -> 'b list -> 'c list -> 'd list

   (* three fold version of List.combine *)
val combine3 : 'a list -> 'b list -> 'c list -> ('a * 'b * 'c) list

(***********************************************************************
 ***********************************************************************
 * 
 * Function composition section
 *)


val (@@) : ('a -> 'b) -> ('b -> 'c) -> 'a -> 'c

(*******************************************************************
 *******************************************************************
 *
 * Option utilities
 *)


val remove_option : 'a option -> 'a 


(*******************************************************************
 *******************************************************************
 *
 * file utilities
 *)

val make_backup : string -> unit


(*** Local Variables: ***)
(*** version-control: t ***)
(*** kept-new-versions: 5 ***)
(*** delete-old-versions: t ***)
(*** time-stamp-line-limit: 30 ***)
(*** End: ***)

