(*
 * The LOOP Project
 *
 * The LOOP Team, Dresden University and Nijmegen University
 *
 * Copyright (C) 2002
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License in file COPYING in this or one of the
 * parent directories for more details.
 *
 * Created 11.10.01 by Hendrik
 *
 * Time-stamp: <Monday 4 August 03 23:13:41 tews@debian>
 *
 * full invariants and bisimulations
 *
 * $Id: full_liftings_theory.ml,v 1.10 2003/08/21 15:15:04 tews Exp $
 *
 *)

open Util
open Top_names
open Name_space
open Top_variant_types
open Logic_util
open Theory_class
open Names
open Types_util
open Classtypes
open Lifting
;;

  
(***********************************************************************
 ***********************************************************************
 *
 * full predicate lifting
 *
 *)

class ['class_type, 'member_type] ccsl_pre_full_invariant_theory 
  (cl : 'class_type) 
  (* the equality relation for initializing the name space *)
  (eq_types : ('class_type, 'member_type) top_pre_types
     -> ('class_type, 'member_type) top_pre_types -> bool)

  : ['class_type, 'member_type] ccsl_pre_class_theory_type =
  object (self : 'self)

    inherit 
      ['class_type, 'member_type] ccsl_pre_class_theory_class cl eq_types
      as top_theory

       (* reserve all names, that we want to declare *)
    initializer reserve ns 
      (
       [ name_of_coalgebra;
         name_of_full_class_pred cl;
         name_of_full_invariance cl;
       ]
      )

    method get_name = ccsl_full_invariant_theory_name cl

    method get_parameters = self#simple_parameters

    initializer top_theory#override_file_name (ccsl_class_file_name cl)

    method private do_imports =
      let do_ancestor = function
	| Resolved_renaming (anc,args,_,_,_) -> 
	    (ccsl_full_invariant_theory_name anc, 
	     self_argument :: args)
						   (* no other stuff *)
	| Unresolved_renaming _
	  -> assert(false)
      in
      let do_component (v,comp, args) accu =
	match comp#get_kind with
	  | Spec_adt -> 
	      if comp#has_feature NeedsMapFeature
	      then (ccsl_adt_every_theory_name comp, args) ::accu
	      else accu
	  | Spec_class -> 
	      (ccsl_greatest_invariance_theory_name comp, 
	       (comp#get_model_type_argument args) :: args) :: accu
	  | Spec_sig -> accu
	  | Spec_Spec -> assert(false)
      in
	Import(
	  (ccsl_interface_theory_name cl, self#simple_arguments)
	  ::
	  ((List.map do_ancestor cl#get_ancestors)
	   @ (List.fold_right do_component cl#get_components [])))



					(* generate full lifting *)
    method private do_full_class_lifting lifting_name method_list =
      let sub_ns = sub_space ns in
      let positive_self_var = match cl#get_self_variance with
	| Pair(-1,-1) -> Pair(-1,0)
	| Unused -> Pos
	| Unset -> assert(false)
	| v -> v
      in
      let var_p = create_ids_with_variance sub_ns
		    [(Function(Self,Bool)), positive_self_var] in
      let ps = variance_flatten var_p in
      let self_var = create_one_id sub_ns Self in
      let type_param_ids = 
	List.map (function TypeParameter id -> id) cl#get_parameters 
      in
				   (* compute the types of the predicates *)
      let var_pred_types = 
	List.map
	  (fun id -> id, Function (BoundTypeVariable(id), Bool))
	  type_param_ids
      in				(* create identifiers *)
      let pred_ids_var = 
	create_ids_with_variance sub_ns 
	  (List.map (fun (id,t) -> t,id.id_variance) var_pred_types)
      in let pred_ids = variance_flatten pred_ids_var in
      let pred_args = List.map (fun (id,t) -> Term(id,Always,[])) pred_ids
      in
      let param_lifting = 
	var_terms_from_var_ids type_param_ids pred_ids_var
      in
      let self_lifting = match List.hd var_p with
	| None, Some(id,_) -> None, Some( Term(id,Always,[]))
	| Some(id,_), None -> Some( Term(id,Always,[])), None
	| Some(id1,_), Some(id2,_) -> 
	    Some( Term(id1,Always,[])), Some(Term(id2,Always,[]))
	| _ -> assert(false)
      in
      let ancestor_list = 
        List.map (function
                    | Resolved_renaming(oanc,args,_,ianc,_) -> oanc,args
                                        (* no other stuff here *)
                    | Unresolved_renaming _
                      -> assert(false)
                 ) cl#get_ancestors
      in
						(* lifting for one ancestor *)
      let do_ancestor (anc, anc_arguments) =
	let body =				       (* coalgebra *)
          Application(
            Term(lifting_name anc, Always,
                 self_argument :: anc_arguments), 
            Application(Term(super_access_method anc, Always,[]), 
			coalgebra_term))
	in 
	let smart_body =			       (* parameter preds *)
	    if anc_arguments = []
	    then body
	    else
	      SmartApplication(
		body,
		argument_list_fullpredlift
		  eq_types
		  (fun x -> x)
		  param_lifting 
		  self_lifting
		  sub_ns
		  anc#get_parameters
		  anc_arguments)
	in
	  Formula(
	    Application(			       (* x *)
              SmartApplication(			       (* PNeg,PPos *)
		smart_body,
		(match (make_simple anc#get_self_variance, List.hd var_p) with
		   | Unused,(_,Some(p,_)) -> [Term(p,Always,[])]
		   | Pos, (_,Some(p,_)) -> [Term(p,Always,[])]
		   | Neg, (Some(p1,_), Some(p2,_))
		       -> [Term(p1,Always,[]); Term(p2,Always,[])]
		   | Mixed, (Some(p1,_), Some(p2,_))
		       -> [Term(p1,Always,[]); Term(p2,Always,[])]
		   | _ -> assert(false)
		)),
		Term(self_var,Always,[])))
      in
        Defn(
	  lifting_name cl,
          [Declared(name_of_coalgebra, self#coalgebra_type)]::
	  (if pred_ids = [] 
	   then []
	   else 
	     [List.map (fun (id,t) -> Undeclared(id,t)) pred_ids]),
	  SmartFunction(
	    (List.map (fun _ -> Function(Self,Bool)) ps),
            Function(Self,Bool)),
          SmartAbstraction
            (ps,
             Abstraction
               ([self_var,Self],
                Expression(
		  And(
		    (List.map do_ancestor ancestor_list)
		    @
		    List.fold_right
			(fun m accu -> 
			   let f = class_pred_lifting
				     eq_types
				     param_lifting
				     self_lifting
				     sub_ns
				     coalgebra_term
				     m
				     self_var
			   in
			     if f = True 
			     then accu
			     else f :: accu)
			method_list
			[]
		  )
		  ))))


	  (* generate full predicate lifting for all methods *)
    method private private_class_pred = 
      self#do_full_class_lifting 
	name_of_full_class_pred cl#get_sig_actions
	
	(* generate public predicate lifting *)
    method private public_class_pred =
      self#do_full_class_lifting
	name_of_full_public_class_pred
	(List.filter
	   (fun m -> m#get_visibility = Public)
	   cl#get_sig_actions)


    method private do_full_invariance =
      let sub_ns = sub_space ns in
      let p = create_one_id sub_ns (Function(Self,Bool)) in
      let self_var = create_one_id sub_ns Self in
      let self_ex = Term(self_var,Always,[]) in
      let pred_ex = Term(p,Always,[]) in
      let type_param_ids = 
	List.map (function TypeParameter id -> id) cl#get_parameters 
      in
				   (* compute the types of the predicates *)
      let var_pred_types = 
	List.map
	  (fun id -> id, Function (BoundTypeVariable(id), Bool))
	  type_param_ids
      in				(* create identifiers *)
      let pred_ids_var = 
	create_ids_with_variance sub_ns 
	  (List.map (fun (id,t) -> t,id.id_variance) var_pred_types)
      in let pred_ids = variance_flatten pred_ids_var in
      let pred_args = List.map (fun (id,t) -> Term(id,Always,[])) pred_ids
      in let inner_ex = 
          Application(				       (* coalgebra *)
            Term(name_of_full_class_pred cl,
		 Always,[]),
            coalgebra_term)
      in let pre_smart_inner_ex =		       (* parameter preds *)
	  if type_param_ids = []
	  then inner_ex
	  else
	    SmartApplication(
	      inner_ex,
	      pred_args)
      in let smart_inner_ex =			       (* with arguments *)
	  if (make_simple cl#get_self_variance) = Mixed 
	  then
	    SmartApplication(
	      pre_smart_inner_ex,
	      [pred_ex; pred_ex])
	  else
	    SmartApplication(
	      pre_smart_inner_ex,
	      [pred_ex])
      in
	Defn(name_of_full_invariance cl,
             [Declared(name_of_coalgebra, self#coalgebra_type)] ::
	     (if pred_ids = [] 
	      then []
	      else 
		[List.map (fun (id,t) -> Undeclared(id,t)) pred_ids]),
             Function(Function(Self,Bool), Bool),
             Abstraction(
               [p,Function(Self,Bool)],
               Expression(
		 Forall(
                   [self_var,Self],
                   Implies(
		     Formula(Application(pred_ex, self_ex)),
                     Formula(
                       Application(
			 smart_inner_ex,
                         self_ex)))))))

      (* 						 
       * For PVS simply output
       *   gfp term
       * for Isabelle convert between 'a set forth and back:
       *   set2pred(gfp (% s . Collect(term (set2pred s)))) 
       * 
       *)
    method private gfp_appl ns settype term = 
      match !Global.output_mode with
	| Pvs_mode ->
	    Application(
	      Term(name_of_gfp,Always,[]),
	      term)
	| Isa_mode ->
	    let sub_ns = sub_space ns in
	    let styp = TypeConstant("set", Always, [TypeArgument(settype)]) in
	    let s = create_one_id sub_ns styp 
	    in
	      Application(
		Term(name_of_set2pred,Always,[]),
		Application(
		  Term(name_of_gfp,Always,[]),
		  Abstraction(
		    [s,styp],
		    Application(
		      Term(name_of_pred2set, Always, []),
		      Application(
			term,
			Application(
			  Term(name_of_set2pred, Always,[]),
			  Term(s,Always,[])
		  ))))))
			      
		

    method private do_every =
      let sub_ns = sub_space ns in
      let p = create_one_id sub_ns (Function(Self,Bool)) in
      let pred_ex = Term(p,Always,[]) in
      let type_param_ids = 
	List.map (function TypeParameter id -> id) cl#get_parameters 
      in
				   (* compute the types of the predicates *)
      let var_pred_types = 
	List.map
	  (fun id -> id, Function (BoundTypeVariable(id), Bool))
	  type_param_ids
      in				(* create identifiers *)
      let pred_ids_var = 
	create_ids_with_variance sub_ns 
	  (List.map (fun (id,t) -> t,id.id_variance) var_pred_types)
      in let pred_ids = variance_flatten pred_ids_var in
      let pred_args = List.map (fun (id,t) -> Term(id,Always,[])) pred_ids

      in let truth = Abstraction(["x", Self], Expression(True)) 
      in let inner_ex = 
          Application(				       (* coalgebra *)
            Term(name_of_full_class_pred cl,
		 Always,[]),
            coalgebra_term)
      in let pre_smart_inner_ex =		       (* parameter preds *)
	  if type_param_ids = []
	  then inner_ex
	  else
	    SmartApplication(
	      inner_ex,
	      pred_args)
      in let smart_inner_ex =			       (* with arguments *)
	  if (make_simple cl#get_self_variance) = Mixed 
	  then
	    Abstraction([p, Function(Self,Bool)],
			SmartApplication(
			  pre_smart_inner_ex,
			  [truth; pred_ex]))
	  else
	    pre_smart_inner_ex
      in
	Defn(name_of_class_every cl,
             [Declared(name_of_coalgebra, self#coalgebra_type)] ::
	     (if pred_ids = [] 
	      then []
	      else 
		[List.map (fun (id,t) -> Undeclared(id,t)) pred_ids]),
             Function(Self, Bool),
	     self#gfp_appl sub_ns Self smart_inner_ex
	    )

    method make_body = 
      [      
	(* USE prelude gfp
	 *
         * Library(name_of_pvs_ccsl_lib, Global.get_pvs_ccsl_lib_location());
	 * LibImport(name_of_pvs_ccsl_lib, 
	 * 	  name_of_fixedpoints, 
	 * 	  [TypeArgument(Function(Self,Bool))]);
         *)
	self#do_imports;
        self#coalgebra_decl;
	self#private_class_pred;
	self#public_class_pred;
	self#do_full_invariance;
	self#do_every;
      ]

end (* ccsl_pre_full_invariance_theory *)

class ccsl_full_invariant_theory cl = 
  [ccsl_iface_type, ccsl_member_type] 
  ccsl_pre_full_invariant_theory cl eq_ccsl_types



(***********************************************************************
 ***********************************************************************
 *
 * full relation lifting
 *
 *)

class ['class_type, 'member_type] ccsl_pre_full_bibisim_theory 
  (cl : 'class_type) 
  (* the equality relation for initializing the name space *)
  (eq_types : ('class_type, 'member_type) top_pre_types
     -> ('class_type, 'member_type) top_pre_types -> bool)

  : ['class_type, 'member_type] ccsl_pre_class_theory_type =
  object (self : 'self)

    inherit 
      ['class_type, 'member_type] ccsl_pre_class_theory_class cl eq_types
      as top_theory

       (* reserve all names, that we want to declare *)
    initializer reserve ns 
      (
       [ name_of_coalgebra;
	 name_of_coalgebra1;
	 name_of_coalgebra2;
         name_of_full_class_pred cl;
         name_of_full_invariance cl;
       ]
      )

    method get_name = ccsl_full_bibisim_theory_name cl

    method private self1_type = BoundTypeVariable self1
    method private self2_type = BoundTypeVariable self2
    method private rel_type = 
      Function(Product([self#self1_type; self#self2_type]), Bool)


    val mutable store_params = None

    method private make_params =
      let p1,a1,t1,p2,a2,t2 = 
	  List.fold_right
	    (fun (id1, id2) (p1l,a1l,t1l,p2l,a2l,t2l) -> 
	       let t1 = BoundTypeVariable(id1) in
	       let t2 = BoundTypeVariable(id2) in
		 (TypeParameter id1) :: p1l,
		 (TypeArgument t1) :: a1l,
		 t1 :: t1l,
		 (TypeParameter id2) :: p2l,
		 (TypeArgument t2) :: a2l,
		 t2 :: t2l)
	    self#double_parameter_ids
	    ([],[],[],[],[],[])
      in
	store_params <- Some((p1,a1,t1,p2,a2,t2))
	  
    method private parameters1 = match store_params with
      | None -> self#make_params; self#parameters1
      | Some((p1,a1,t1,p2,a2,t2)) -> p1

    method private arguments1 = match store_params with
      | None -> self#make_params; self#arguments1
      | Some((p1,a1,t1,p2,a2,t2)) -> a1

    method private types1 = match store_params with
      | None -> self#make_params; self#types1
      | Some((p1,a1,t1,p2,a2,t2)) -> t1

    method private parameters2 = match store_params with
      | None -> self#make_params; self#parameters2
      | Some((p1,a1,t1,p2,a2,t2)) -> p2

    method private arguments2 = match store_params with
      | None -> self#make_params; self#arguments2
      | Some((p1,a1,t1,p2,a2,t2)) -> a2

    method private types2 = match store_params with
      | None -> self#make_params; self#types2
      | Some((p1,a1,t1,p2,a2,t2)) -> t2


    method private subst1 =
      ((Self, self#self1_type) :: 
	 (List.combine (types_from_parameters orig_parameters)
	    self#types1))

    method private subst2 =
      ((Self, self#self2_type) ::
	 (List.combine (types_from_parameters orig_parameters)
	    self#types2))

    method get_parameters = 
	self#self1_parameter :: self#self2_parameter :: 
	  (self#parameters1 @ self#parameters2)

    initializer top_theory#override_file_name (ccsl_class_file_name cl)


	(* override these two methods to get the coalgebra 
	 * declarations right
	 *)
    method coalgebra1_type = 
      IFace( cl, Always, self#self1_argument :: self#arguments1)
	       

    method coalgebra2_type = 
      IFace( cl, Always, self#self2_argument :: self#arguments2)


    method private do_imports =
      let do_ancestor = function
	| Resolved_renaming (anc,args,_,_,_) -> 
	    (ccsl_full_bibisim_theory_name anc, 
	     self#self1_argument
	     :: self#self2_argument
	     :: ((ccsl_substitute_arguments self#subst1 args) 
		 @ (ccsl_substitute_arguments self#subst2 args)))
						   (* no other stuff *)
	| Unresolved_renaming _
(* NO JAVA ANCESTORS
 * 	   | Resolved_ancestor _ 
 * 	   | Unresolved_ancestor _ 
 *)
	  -> assert(false)
      in
      let do_component (v, comp, args) accu =
	let subst_args1 = 
	  ccsl_substitute_arguments self#subst1 args
	in let subst_args2 =
	    ccsl_substitute_arguments self#subst2 args
	in let subst_args = subst_args1 @ subst_args2
	in
	  match comp#get_kind with
	    | Spec_adt -> 
		(ccsl_adt_rellift_theory_name comp, subst_args) :: accu
	    | Spec_class -> 
		(ccsl_greatest_bibisim_theory_name comp, 
		 (comp#get_model_type_argument subst_args1) ::
		 (comp#get_model_type_argument subst_args2) ::
		 subst_args) :: accu
	    | Spec_sig -> accu
	    | Spec_Spec -> assert(false)
      in
	Import(
	  (ccsl_interface_theory_name cl, 
	   self#self1_argument :: self#arguments1) ::
	  (ccsl_interface_theory_name cl, 
	   self#self2_argument :: self#arguments2) ::
	  ((List.map do_ancestor cl#get_ancestors)
	   @ (List.fold_right do_component cl#get_components [])))


					(* generate full lifting *)
    method private do_full_class_rellifting lift_name method_list =
      let sub_ns = sub_space ns in
      let positive_self_var = match cl#get_self_variance with
	| Pair(-1,-1) -> Pair(-1,0)
	| Unused -> Pos
	| Unset -> assert(false)
	| v -> v
      in
      let var_r = create_ids_with_variance sub_ns 
		[(self#rel_type, positive_self_var)]
      in
      let rs = variance_flatten var_r in
      let xid, yid = create_id_pairs sub_ns [Self] in
      let xname = fst(List.hd xid) in
      let yname = fst(List.hd yid) in
      let type_param_ids = 
	List.map (function TypeParameter id -> id) cl#get_parameters 
      in
				   (* compute the types of the predicates *)
      let var_rel_types = 
	Util.map3
	  (fun oid t1 t2 -> (Function (Product([t1; t2]), Bool),
			     oid.id_variance))
	  type_param_ids self#types1 self#types2
      in				(* create identifiers *)
      let rel_ids_var = 
	create_ids_with_variance sub_ns var_rel_types in

      let rel_ids = variance_flatten rel_ids_var in
      let rel_args = List.map (fun (id,t) -> Term(id,Always,[])) rel_ids
      in
      let self1_subst = substitute_types_only eq_types self#subst1 in
      let self2_subst = substitute_types_only eq_types self#subst2 in

      let param_rel_lifting = 
	var_terms_from_var_ids type_param_ids rel_ids_var
      in
      let self_lifting = match List.hd var_r with
	| None, Some(id,_) -> None, Some( Term(id,Always,[]))
	| Some(id,_), None -> Some( Term(id,Always,[])), None
	| Some(id1,_), Some(id2,_) -> 
	    Some( Term(id1,Always,[])), Some(Term(id2,Always,[]))
	| _ -> assert(false)
      in
      let ancestor_list = 
        List.map (function
                    | Resolved_renaming(oanc,args,_,ianc,_) -> oanc,args
                                        (* no other stuff here *)
                    | Unresolved_renaming _
                      -> assert(false)
                 ) cl#get_ancestors
      in
      let do_ancestor (anc, anc_arguments) =
	let body =				   (* coalgebras *)
	  SmartApplication(
	    Term(lift_name anc, Always,
		 self#self1_argument :: self#self2_argument ::
		   ((ccsl_substitute_arguments self#subst1 anc_arguments)
		    @(ccsl_substitute_arguments self#subst2 anc_arguments) )), 
	    [Application(
	       Term(super_access_method anc, Always,[]), 
	       coalgebra1_term);
	     Application(
	       Term(super_access_method anc, Always,[]), 
	       coalgebra2_term)])

	in let smart_body =			   (* parameters *)
	    if anc_arguments = []
	    then body
	    else
	      SmartApplication(
		body,
		argument_list_fullrellift
		  eq_types
		  self1_subst 
		  self2_subst
		  param_rel_lifting 
		  self_lifting
		  sub_ns
		  anc#get_parameters
		  anc_arguments)	
	in
	  Formula(
            Application(			   (* x and y *)
	      SmartApplication(			   (* rels *)
		smart_body,
		(match (make_simple anc#get_self_variance, List.hd var_r) with
		   | Unused,(_,Some(r,_)) -> [Term(r,Always,[])]
		   | Pos, (_,Some(r,_)) -> [Term(r,Always,[])]
		   | Neg, (Some(r1,_), Some(r2,_))
		       -> [Term(r1,Always,[]); Term(r2,Always,[])]
		   | Mixed, (Some(r1,_), Some(r2,_))
		       -> [Term(r1,Always,[]); Term(r2,Always,[])]
		   | _ -> assert(false)
		)),
              Tuple([Term(xname, Always,[]);
		     Term(yname, Always,[])])))
	
      in
        Defn(
	  lift_name cl,
          [Declared(name_of_coalgebra1, self#coalgebra1_type);
	   Declared(name_of_coalgebra2, self#coalgebra2_type);
	  ] ::
	  (if rel_ids = [] 
	   then []
	   else 
	     [List.map (fun (id,t) -> Undeclared(id,t)) rel_ids]),
	  SmartFunction(
	    (List.map (fun _ -> self#rel_type) rs),
	    self#rel_type),
          SmartAbstraction
            (rs,
             Abstraction
               ([(xname, self#self1_type); (yname, self#self2_type)],
                Expression(
		  And(
		    (List.map do_ancestor ancestor_list)
		    @
		    (List.map
		       (fun m -> 
			  class_method_full_rel_lifting
			    eq_types
			    self1_subst		   (* self1_subst *)
			    self2_subst		   (* self2_subst *)
			    param_rel_lifting	   (* param_lifting  *)
			    self_lifting	   (* self_lifting *)
			    sub_ns		   (* name_space *)
			    coalgebra1_term	   (* coalgebra1 *)
			    coalgebra2_term	   (* coalgebra2 *)
			    m			   (* method_list *)
			    xname		   (* selfvar1 *)
			    yname)		   (* selfvar2 *)
		       method_list)
		  )))))

	  (* generate full relation lifting for all methods *)
    method private private_class_rel = 
      self#do_full_class_rellifting 
	name_of_full_class_rel cl#get_sig_actions
	
	(* generate public relation lifting *)
    method private public_class_rel =
      self#do_full_class_rellifting
	name_of_full_public_class_rel
	(List.filter
	   (fun m -> m#get_visibility = Public)
	   cl#get_sig_actions)


    method private do_full_bisimulation =
      let sub_ns = sub_space ns in
      let r = create_one_id sub_ns self#rel_type in
      let r_ex = Term(r,Always,[]) in
      let xid, yid = create_id_pairs sub_ns [Self] in
      let xname,yname = match xid,yid with
	| [(x,_)],[(y,_)] -> x,y
	| _ -> assert(false)
      in let xy_term = Tuple([Term(xname,Always,[]); Term(yname,Always,[])])
      in
      let type_param_ids = 
	List.map (function TypeParameter id -> id) cl#get_parameters 
      in
				   (* compute the types of the relations *)
      let var_rel_types = 
	Util.map3
	  (fun oid t1 t2 -> (Function (Product([t1; t2]), Bool),
			     oid.id_variance))
	  type_param_ids self#types1 self#types2
      in				(* create identifiers *)
      let rel_ids_var = 
	create_ids_with_variance sub_ns var_rel_types in

      let rel_ids = variance_flatten rel_ids_var in
      let rel_args = List.map (fun (id,t) -> Term(id,Always,[])) rel_ids
      in
      let body_ex =				   (* with coalgebras *)
          SmartApplication(
            Term(name_of_full_class_rel cl,
		 Always,[]),
            [coalgebra1_term; coalgebra2_term])
      in let pre_smart_body_ex =		   (* with parameters *)
	  if type_param_ids = []
	  then body_ex
	  else
	    SmartApplication(
	      body_ex,
	      rel_args)
      in let smart_body_ex =			   (* with arguments *)
	  if (make_simple cl#get_self_variance) = Mixed 
	  then
	    SmartApplication(
	      pre_smart_body_ex,
	      [r_ex; r_ex])
	  else
	    SmartApplication(
	      pre_smart_body_ex,
	      [r_ex])
      in
	Defn(name_of_full_bibisimulation cl,
             [Declared(name_of_coalgebra1, self#coalgebra1_type);
	      Declared(name_of_coalgebra2, self#coalgebra2_type);
	     ] ::
	     (if rel_ids = [] 
	      then []
	      else 
		[List.map (fun (id,t) -> Undeclared(id,t)) rel_ids]),
             Function(self#rel_type, Bool),
             Abstraction(
               [r,self#rel_type],
               Expression(
		 Forall(
                   [(xname,self#self1_type); (yname, self#self2_type)],
                   Implies(
		     Formula(Application(r_ex, xy_term)),
                     Formula(
                       Application(
			 smart_body_ex,
                         xy_term)))))))
                                              

      (* 						 
       * For PVS simply output
       *   gfp term
       * for Isabelle convert between 'a set forth and back:
       *   set2pred(gfp (% s . Collect(term (set2pred s)))) 
       * 
       *)
    method private gfp_appl ns settype term = 
      match !Global.output_mode with
	| Pvs_mode ->
	    Application(
	      Term(name_of_gfp,Always,[]),
	      term)
	| Isa_mode ->
	    let sub_ns = sub_space ns in
	    let styp = TypeConstant("set", Always, [TypeArgument(settype)]) in
	    let s = create_one_id sub_ns styp 
	    in
	      Application(
		Term(name_of_set2pred,Always,[]),
		Application(
		  Term(name_of_gfp,Always,[]),
		  Abstraction(
		    [s,styp],
		    Application(
		      Term(name_of_pred2set, Always, []),
		      Application(
			term,
			Application(
			  Term(name_of_set2pred, Always,[]),
			  Term(s,Always,[])
		  ))))))

    method private do_relevery =
      let sub_ns = sub_space ns in
      let r = create_one_id sub_ns self#rel_type in
      let rel_ex = Term(r,Always,[]) in
      let type_param_ids = 
	List.map (function TypeParameter id -> id) cl#get_parameters 
      in
				   (* compute the types of the relations *)
      let var_rel_types = 
	Util.map3
	  (fun oid t1 t2 -> (Function (Product([t1; t2]), Bool),
			     oid.id_variance))
	  type_param_ids self#types1 self#types2
      in				(* create identifiers *)
      let rel_ids_var = 
	create_ids_with_variance sub_ns var_rel_types in

      let rel_ids = variance_flatten rel_ids_var in
      let rel_args = List.map (fun (id,t) -> Term(id,Always,[])) rel_ids
      in

      let inner_ex = 
          SmartApplication(				       (* coalgebra *)
            Term(name_of_full_class_rel cl,
		 Always,[]),
            [coalgebra1_term; coalgebra2_term])
      in let pre_smart_inner_ex =		       (* parameter preds *)
	  if type_param_ids = []
	  then inner_ex
	  else
	    SmartApplication(
	      inner_ex,
	      rel_args)
      in let smart_inner_ex =			       (* with arguments *)
	  if (make_simple cl#get_self_variance) = Mixed 
	  then
	    Abstraction([r, self#rel_type],
			SmartApplication(
			  pre_smart_inner_ex,
			  [rel_ex; rel_ex]))
	  else
	    pre_smart_inner_ex
      in
	Defn(name_of_class_rel_every cl,
             [Declared(name_of_coalgebra1, self#coalgebra1_type);
	      Declared(name_of_coalgebra2, self#coalgebra2_type);
	     ] ::
	     (if rel_ids = [] 
	      then []
	      else 
		[List.map (fun (id,t) -> Undeclared(id,t)) rel_ids]),
             self#rel_type,
	     self#gfp_appl sub_ns 
	       (Product[self#self1_type; self#self2_type])
	       smart_inner_ex
	    )



    method make_body = 
      [      
	(* USE prelude gfp
	 *
         * Library(name_of_pvs_ccsl_lib, Global.get_pvs_ccsl_lib_location());
	 * LibImport(name_of_pvs_ccsl_lib, 
	 * 	  name_of_fixedpoints, 
	 * 	  [TypeArgument(self#rel_type)]);
         *)
	self#do_imports;
        (self#coalgebra1_decl);
        (self#coalgebra2_decl);
	self#private_class_rel;
	self#public_class_rel;
        self#do_full_bisimulation
      ]
      @ ( 
	if cl#has_feature HasRelLiftFeature
	then
	  [self#do_relevery]
	else
	  []
      )

end (* ccsl_pre_full_bibisim_theory *)

class ccsl_full_bibisim_theory cl = 
  [ccsl_iface_type, ccsl_member_type] 
  ccsl_pre_full_bibisim_theory cl eq_ccsl_types




(*** Local Variables: ***)
(*** version-control: t ***)
(*** kept-new-versions: 5 ***)
(*** delete-old-versions: t ***)
(*** time-stamp-line-limit: 30 ***)
(*** End: ***)


