(*
 * The LOOP Project
 *
 * The LOOP Team, Dresden University and Nijmegen University
 *
 * Copyright (C) 2002
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License in file COPYING in this or one of the
 * parent directories for more details.
 *
 * Created 1.10.97 by Hendrik
 *
 * Time-stamp: <Tuesday 13 August 02 16:32:33 tews@ithif51>
 *
 * Utility functions for ccsl parser
 *
 * $Id: parser.mli,v 1.15 2002/09/18 15:35:04 tews Exp $
 *
 *)

open Top_variant_types
open Classtypes;;

    (* keeps the last lexed location, for parse errors *)

val last_loc : location_type ref


    (* At some places we need inherited attributes in the grammar. 
     * For instance the reduction rules for methods and constructors 
     * must have access to the currently created iface. 
     * 
     * We use a global variable, holding the currently parsed iface, 
     * whenever available. The function cif, ccl and cadt 
     * provides some shortcut for 
     * access
     *)

type parsing_type = 
  | Parse_Nothing
  | Parse_IFace of ccsl_iface_type
  | Parse_Class of  ccsl_iface_type 
  | Parse_Adt of ccsl_iface_type
  | Parse_Sig of ccsl_iface_type
  | Parse_Anon of ccsl_iface_type

val current_iface : parsing_type ref

val ciface     : unit -> ccsl_iface_type
val ccl        : unit -> ccsl_iface_type
val cadt       : unit -> ccsl_iface_type
val csig       : unit -> ccsl_iface_type


    (* same applies to current_visibility. Visibility modifiers
     * occur at the beginning of a method section.
     * Their value is stored here
     *)
val current_visibility : top_visibility ref

  
    (* the internal representation of nat *) 
val ground_type_nat : location_type -> ccsl_input_types

    (* make a new location spanning the two arguments *)
val new_loc : location_type -> location_type -> location_type


(**********************************************************************
 **********************************************************************
 * 
 * context checks, type checks
 *
 *)

    (* checks if the name at the end of a data specification is matched *)
val check_closing_id : string -> token_type -> unit


(**********************************************************************
 **********************************************************************
 * 
 * make approbriate entries in the symboltable
 *
 *)


    (* action for paramdeclaration 1*)
val add_type_parameter : variance_type -> token_type -> ccsl_parameter_type

    (* check for unique type parameters *)
val unique_type_parameter_check : ccsl_parameter_type list -> unit

    (* check for variance <> (?,?) *)
val do_exact_variance : location_type -> int -> int -> variance_type

    (* action for declaration 1 *)
val add_class : ccsl_iface_type -> ccsl_ast option

    (* action for declaration 1.5 *)
val add_adt : ccsl_iface_type -> ccsl_ast option

    (* action for ground type completion *)
val add_groundtype : 
  token_type -> ccsl_parameter_type list -> 
      ccsl_input_types option -> unit

    (* action for ground terms *)
val add_groundterm : 
  token_type -> ccsl_member_sort -> ccsl_parameter_type list ->
      ccsl_input_types -> ccsl_assertion option -> unit

    (* check infix ground terms *)
val check_infix : 
  token_type -> ccsl_input_types -> unit

    (* action for signatures *)
val add_sig : ccsl_iface_type -> ccsl_ast option

(*****************************************************************
 * 
 * anonymous ground signatures
 *)

  (* start an anon ground sig if
   * - we are not in a regular ground sig and either
   * - there is no anon ground sig
   * - the parameter list is nonempty
   *)
val start_anon_ground_sig : 
  token_type -> ccsl_parameter_type list -> ccsl_ast option

val close_anon_ground_sig : unit -> unit

(********************************************************************
 * 
 * Semantic action section
 *
 *)

   (* action for BEGIN ID *)
val do_iface_start : token_type -> unit

   (* action for end of ADT *)
val do_adt_end: location_type -> token_type -> ccsl_iface_type

   (* action for end of Classes *)
val do_class_end: 
  location_type -> ccsl_importing_type list -> token_type -> ccsl_iface_type

   (* action for end of ground signatures *)
val do_sig_end: 
  location_type -> ccsl_importing_type list -> token_type -> ccsl_iface_type

    (* action for pvs_type Product *)
val do_type_product : 
  ccsl_input_types list -> location_type -> ccsl_input_types

    (* action for type application *)
val do_type_appl : token_type -> ccsl_argument_type list -> ccsl_input_types

    (* action for the optional class in Always and eventually *)
val do_instclass : token_type -> ccsl_argument_type list -> ccsl_input_types

    (* action for inherit: find a class or print an error *)
val do_inherit : token_type -> ccsl_argument_type list -> 
  (ccsl_renaming list * location_type option) -> ccsl_ancestor_type

    (* action for identifiers in argument lists *)
val do_argument_id : token_type -> ccsl_argument_type

val do_qualified_type_id : 
  token_type option * ccsl_argument_type list option 
                             * location_type option * token_type -> 
      ccsl_input_types

    (* do a class constructor *)
val do_class_constructor : token_type -> ccsl_input_types -> unit 

(* DELETE
 *     (* do a parametrized class constructor *)
 * val do_var_class_constructor : token_type -> ccsl_input_types -> ccsl_input_types -> unit 
 * 
 *)

    (* do a attribute *)
val do_attribute : token_type -> ccsl_input_types -> unit 

    (* do a method *)
val do_method : token_type ->  ccsl_input_types -> unit 

    (* do class imports *)
val do_class_imports : ccsl_importing_type list -> unit

    (* do a definitional extension *)
val do_definition : token_type -> ccsl_input_types -> ccsl_assertion -> unit

    (* do assertion imports, var declarations *)
val do_assertion_start : 
  ccsl_importing_type list -> token_type * ccsl_input_types ->
      (token_type * ccsl_input_types) list -> 
      ccsl_identifier_record_type * ccsl_identifier_record_type list

    (* do an assertion *)
val do_assertion : 
  token_type -> 
    ccsl_identifier_record_type * ccsl_identifier_record_type list -> 
      ccsl_assertion -> unit

    (* do assertion imports, var declarations *)
val do_creation_start : 
  location_type -> 
    ccsl_importing_type list -> 
      (token_type * ccsl_input_types) list -> 
        ccsl_identifier_record_type list

    (* do a creation condition *)
val do_creation : token_type -> ccsl_identifier_record_type list -> 
  ccsl_assertion -> unit


    (* do theorem imports, var declarations *)
val do_theorem_start : 
  ccsl_importing_type list -> 
    (token_type * ccsl_input_types) list -> 
      ccsl_identifier_record_type list

    (* do a theorem condition *)
val do_theorem : token_type -> ccsl_identifier_record_type list -> 
  ccsl_assertion -> unit

   (* Create an identifier record for a CCSL_Var
    *)
val do_id_declaration :
  token_type * ccsl_input_types -> ccsl_identifier_record_type


   (* creates an optional selfvar "x", if nothing was declared *)
val do_selfvar_default : unit -> token_type * ccsl_input_types

(* DELETE
 *     (* doing the constant adt constructor, name, accessor list, 
 * 	* codomain type (must be `Carrier)
 * 	*)
 * val do_const_adt_constructor : token_type -> token_type list -> 
 *   ccsl_input_types -> unit
 * 
 *)
    (* doing the general adt constructor, name, accessor list, 
     * domain type, codomain type (must be `Carrier)
     *)
val do_adt_constructor : token_type -> token_type list -> 
  ccsl_input_types -> unit

    (* give `Self back, if we are parsing a class *)
val self_action : location_type -> ccsl_input_types

    (* give `Carrier back, if we are parsing an adt *)
val carrier_action : location_type -> ccsl_input_types

    (* Arguments: 
     *   ADT_token          contains the ADT name
     *   ADT_arguments      contains the instanciation (ADT arguments)
     *   id_token           contains the member name
     *
     * gives the internal representation of the (suitably instantiated) 
     * constructor of the ADT/Class/Sig
     * action for method selection
     * within hol_formula
     *)
val do_method_selection : ccsl_expressions ->
  token_type option * ccsl_argument_type list option 
                             * location_type option * token_type -> 
      ccsl_formulas

    (* action for qualified id's in term position *)
val do_qualified_term_id : 
  token_type option * ccsl_argument_type list option 
                             * location_type option * token_type -> 
      ccsl_expressions

    (* action for case patterns *)
val do_case_pattern : token_type * token_type list ->
      ccsl_expressions ->
      ccsl_member_type container * ccsl_identifier_record_type list *
      ccsl_expressions

    (* actions for and and or *)

val do_and : ccsl_formulas -> ccsl_formulas -> ccsl_formulas

val do_or : ccsl_formulas -> ccsl_formulas -> ccsl_formulas


    (*******************************************************************
     *
     * error messages
     *)

val instantiation_error :
  location_type -> string -> ccsl_parameter_type list -> 
      ccsl_argument_type list -> unit



(*** Local Variables: ***)
(*** version-control: t ***)
(*** kept-new-versions: 5 ***)
(*** delete-old-versions: t ***)
(*** time-stamp-line-limit: 30 ***)
(*** End: ***)



