(*
 * The LOOP Project
 *
 * The LOOP Team, Dresden University and Nijmegen University
 *
 * Copyright (C) 2002
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License in file COPYING in this or one of the
 * parent directories for more details.
 *
 * Created 14.5.99 by Hendrik
 *
 * Time-stamp: <Tuesday 19 August 03 23:10:40 tews@debian>
 *
 * generate batch file for pvs or Isabelle
 *
 * $Id: pvs_batch.ml,v 1.7 2003/08/21 15:14:58 tews Exp $
 *
 *)

open Filename
open Unix
open Util
open Global
open Top_variant_types

(***********************************************************************
 ***********************************************************************
 *
 * the main loop of the compiler iterates on single input files,
 * but the batch should contain everything, therefore you can register 
 * theories and generate the batch at the end
 *
 *)

    (* !!  reverse order !! *)
let file_list : string list ref = ref [] 

let register_theories thl =
  List.iter (fun th -> (if not (List.mem th#get_file_name !file_list)
			then file_list := th#get_file_name :: !file_list))
    thl

let output_pvs_batch name = 
  let flags = [Open_wronly; Open_text; Open_creat; Open_trunc] in
  let file_name = (concat (get_target_directory()) name) in
  let _ = make_backup file_name in
  let oc = open_out_gen flags 0o666 file_name in
  let o = output_string oc in
    o ( ";;;  Loop Project Version 2 \n\
         ;;;  control batch file for typechecking test files  \n\
         ;;; \n\
         ;;; files contains the list of pvs files to typecheck \n\
         ;;; since there might be no valid pvs context it is important that \n\
         ;;; the files come in the right order  \n\
         ;;; (do not forget ccsl-prelude.pvs !) \n\
         ;;; \n\
         ;;; use -batch option of the loop compiler to generate this file \n\
         ;;; \n\
         ;;; to start pvs in batch mode, type \n\
         ;;;     pvs -batch -v <verbos-value> -l <this file> \n\
         ;;; where verbose-value is between 0 and 3 \n\
         ;;;
             \n\
         (setq files '(\n");
    List.fold_right
      (fun n () -> o ("\t  \"" ^ n ^ "\"\n"))
      !file_list ();
    o "\t))\n\n";
    o (";;; the body: typecheck each of the files \n\
         \n\
	(setq current-prefix-arg t) \n\
	(mapcar (lambda (f) \n\
	     \t(message (concat \"\\n--> Typechecking \" f \"\\n\")) \n\
	     \t(typecheck f) \n\
	     \t;(prove-pvs-file f) \n\
	     \t) \n\
	files) \n\
       ");
    close_out oc


let output_isa_batch name = 
  let flags = [Open_wronly; Open_text; Open_creat; Open_trunc] in
  let file_name = (concat (get_target_directory()) name) in
  let _ = make_backup file_name in
  let oc = open_out_gen flags 0o666 file_name in
  let o = output_string oc in
    o ( "(* Loop Project Version 2 \n\
          * control batch file for typechecking test files  \n\
          * \n\
          * files contains the list of isabelle files to typecheck \n\
          * \n\
          * use -batch option of the loop compiler to generate this file \n\
          * \n\
          *) 
             \n\
         val files = [\n");
    match !file_list with
      | [] -> ()
      | f::fl -> 
	  List.fold_right
	    (fun f () -> o ("\t  \"" ^ f ^ "\",\n"))
	    fl ();
	  o ("\t  \"" ^ f ^ "\"\n");
    o "\t];\n\n";
    o ("(* the body: typecheck each of the files *)\n\
         \n\
	map (fn f => \n\
	     \t update_thy f) \n\
	files; \n\
       ");
    close_out oc



(*** Local Variables: ***)
(*** version-control: t ***)
(*** kept-new-versions: 5 ***)
(*** delete-old-versions: t ***)
(*** time-stamp-line-limit: 30 ***)
(*** End: ***)

