(*
 * The LOOP Project
 *
 * The LOOP Team, Dresden University and Nijmegen University
 *
 * Copyright (C) 2002
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License in file COPYING in this or one of the
 * parent directories for more details.
 *
 * Adapted from version 0.6.4 on  1.7.99 by Hendrik
 *
 * Time-stamp: <Saturday 11 May 02 18:50:30 tews@ithif56.inf.tu-dresden.de>
 *
 * Interface of the PVS Pretty printing module
 *
 * $Id: pvs_pretty.mli,v 1.5 2002/05/22 13:42:46 tews Exp $
 *
 *)


open Top_variant_types
open Top_classtypes

    (******************************************************************
     *
     * pretty printing through the standart formatter
     *)
  
val pvs_pp_theory : 
  (<get_name : string; 
    has_feature : feature_type -> bool;
    ..>, 
   <get_name : string; ..>)
      #top_pre_theory_body_type -> unit 

val pvs_pp_top_theory_declaration :
  (<get_name : string; 
    has_feature : feature_type -> bool;
    ..>, 
   <get_name : string; ..>)
  top_pre_theory_declaration -> unit

val pvs_pp_th_proofs : string -> pvs_proof list -> unit

val pvs_pp_edit_proof : string -> pvs_proof_tree -> unit

    (******************************************************************
     *
     * string interface
     *)

val string_of_pvs_top_expression :
  (<get_name : string; 
    has_feature : feature_type -> bool;
    ..>, 
   <get_name : string; ..>)
  top_pre_expressions -> string



(*** Local Variables: ***)
(*** version-control: t ***)
(*** kept-new-versions: 5 ***)
(*** delete-old-versions: t ***)
(*** time-stamp-line-limit: 30 ***)
(*** End: ***)

