(*
 * The LOOP Project
 *
 * The LOOP Team, Dresden University and Nijmegen University
 *
 * Copyright (C) 2002
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License in file COPYING in this or one of the
 * parent directories for more details.
 *
 * Created 9.3.02 by Hendrik
 *
 * Time-stamp: <Thursday 21 August 03 14:46:29 tews@ithif51.inf.tu-dresden.de>
 *
 * top level class structure
 *
 * $Id: top_classes.mli,v 1.3 2003/08/21 15:14:57 tews Exp $
 *
 *)

(*
 * Polymorphic classes are introduced for iface, member and
 * theory_body used at top level, from which classes for all
 * translations (Ccsl, Java, ...) inherit. The type variables
 * like 'member_type, 'theory_body and 'super_class are still
 * used in these implementations.
 *
 * The following three classes are introduced.
 *   ['member_type, 'theory_body_type, 'super_class] top_pre_iface_class
 *   ['class_type] top_pre_member_class
 *   ['class_type] top_pre_theory_body_class
 *
 *)

open Top_variant_types
open Top_classtypes

class virtual 
  ['member_type, 'theory_body_type, 'super_class] top_pre_iface_class :
  token_type ->				(* the name *)
					(* the local symbol table *)
    ('super_class, 'member_type) top_pre_scope_type ->

(* here should come top_pre_iface_type with some constraints
 * but there is no concrete syntax for that, so use an ad hoc type
 * 
 * if constraints do not match: simply copy them from the 
 * compiler error messages
 *)

object
  inherit ['member_type, 'theory_body_type, 'super_class] top_pre_iface_type 

  constraint 'member_type = 
    < (* get_name : string; *)
      is_action : bool;
      is_adt_constructor : bool; 
      is_attribute : bool;
      is_constructor : bool; 
      is_method : bool; 
      is_sig_action : bool; 
    .. >
  constraint 'super_class =
    < get_all_ancestors : 'super_class list; 
      get_all_members : 'member_type list;
      get_name : string; 
    .. >
end



class  ['class_type, 'member_type] top_pre_member_class :
  token_type ->				(* the name *)
    token_type list ->			(* old names *)
      ('class_type, 'member_type) top_pre_types ->(* domain *)
	('class_type, 'member_type) top_pre_types ->(* codomain *)
	  top_visibility ->		(* visibility *)
	    'member_type top_pre_member_sort ->(* sort *)
               ['class_type, 'member_type] top_pre_member_type

(* DELETE
 * object
 *   inherit ['class_type, 'member_type] top_pre_member_type
 * 
 *   (\* 
 *    * constraint 'class_type  = < get_name : string; .. >
 *    * constraint 'member_type = < get_name : string; .. >
 *    *\)
 * end
 *)


class virtual ['class_type, 'member_type] top_pre_theory_body_class :

(* instead of   : ['class_type, 'member_type] top_pre_theory_body_type *)

object 
  inherit ['class_type, 'member_type] top_pre_theory_body_type

end




(*** Local Variables: ***)
(*** version-control: t ***)
(*** kept-new-versions: 5 ***)
(*** delete-old-versions: t ***)
(*** time-stamp-line-limit: 30 ***)
(*** End: ***)
