(*
 * The LOOP Project
 *
 * The LOOP Team, Dresden University and Nijmegen University
 *
 * Copyright (C) 2002
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License in file COPYING in this or one of the
 * parent directories for more details.
 *
 * Created 14.5.99 by Hendrik
 *
 * Time-stamp: <Wednesday 20 August 03 17:11:23 tews@debian>
 *
 * Utility functions for variant types
 *
 * $Id: top_variant_types_util.mli,v 1.2 2003/08/21 15:14:57 tews Exp $
 *
 *)

open Top_variant_types

val is_form_loc : ('cl, 'mem) top_pre_formulas -> bool

val is_expr_loc : ('cl, 'mem) top_pre_expressions -> bool

val resolution_of : 'a container -> 'a

val ancestor_resolution_of : ('cl, 'mem) top_pre_ancestor_type -> 'cl

val dump_symbol_brief : 
  (<get_name : string; .. >, <get_name : string; ..>) top_pre_symbol_type 
    -> string


(*** Local Variables: ***)
(*** version-control: t ***)
(*** kept-new-versions: 5 ***)
(*** delete-old-versions: t ***)
(*** time-stamp-line-limit: 30 ***)
(*** End: ***)
