(*
 * The LOOP Project
 *
 * The LOOP Team, Dresden University and Nijmegen University
 *
 * Copyright (C) 2002
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License in file COPYING in this or one of the
 * parent directories for more details.
 *
 * Created 11.10.01 by Hendrik
 *
 * Time-stamp: <Wednesday 24 July 02 16:30:23 tews@ithif51>
 *
 * addon theories 
 *
 * $Id: emptytype_theory.ml,v 1.6 2002/09/18 15:35:03 tews Exp $
 *
 *)

(***********************************************************************
 ***********************************************************************
 *
 * In this file there are additional theories for
 *   - empty type in pvs
 *   - empty function in pvs
 *   - sets2pred : 'a set => 'a => bool in isabelle
 *
 *)



open Name_space
open Top_names
open Names
open Top_variant_types  
open Pvs_proof_util
open Theory_class
open Iface_class
open Classtypes
open Types_util
;;


(*******************************************************************
 *******************************************************************
 *
 * Empty class for technical reasons
 *
 *)


let emptytoken = { token_name = "";
		   loc = None 
		 }

let empty_iface = 
  new ccsl_pre_iface_class emptytoken (Symbol.new_local ()) true
;;   
empty_iface#inheritance_done
;;


(***********************************************************************
 ***********************************************************************
 *
 * empty type definition
 *
 *)

class ['class_type, 'member_type] ccsl_pre_empty_type_theory 
  (cl : 'class_type) 
  (* the equality relation for initializing the name space *)
  (eq_types : ('class_type, 'member_type) top_pre_types
     -> ('class_type, 'member_type) top_pre_types -> bool)

  : ['class_type, 'member_type] ccsl_pre_sig_theory_type =
  object (self : 'self)

    inherit 
      ['class_type, 'member_type] ccsl_pre_sig_theory_class cl eq_types
      as top_theory

       (* reserve all names, that we want to declare *)
    initializer reserve ns 
      (
       [ name_of_empty_type;
       ]
      )

    method get_name = ccsl_empty_type_defn_theory_name

    method get_parameters = []

    initializer top_theory#override_file_name ccsl_prelude_name

(* ISAR
 *     method get_proofs = []
 *)


    method private emptytype =
      let bool_var = "b" 
      in
	Typedecl(
	  [],
	  name_of_empty_type,
	  Predtype(
	    Formula(
	      Abstraction(
		[bool_var, Bool],
		Expression(False)))))
	      

    method make_body = 
      [      
	self#emptytype
      ]

end (* ccsl_pre_empty_type_theory *)

class ccsl_empty_type_theory = 
  [ccsl_iface_type, ccsl_member_type] 
  ccsl_pre_empty_type_theory
    empty_iface
    eq_ccsl_types


(***********************************************************************
 ***********************************************************************
 *
 * empty function definition
 *
 *)

class ['class_type, 'member_type] ccsl_pre_empty_fun_theory 
  (cl : 'class_type) 
  (* the equality relation for initializing the name space *)
  (eq_types : ('class_type, 'member_type) top_pre_types
     -> ('class_type, 'member_type) top_pre_types -> bool)

  : ['class_type, 'member_type] ccsl_pre_sig_theory_type =
  object (self : 'self)

    inherit 
      ['class_type, 'member_type] ccsl_pre_sig_theory_class cl eq_types
      as top_theory

       (* reserve all names, that we want to declare *)
    initializer reserve ns 
      (
       [ name_of_empty_fun;
       ]
      )

    val other_type_id = 
		 { id_token = { token_name = "A";
				loc = None };
		   (* the other fields are to ignored *)
		   id_type = Self;
		   id_origin = CCSL_TypeParameter;
		   id_parameters = [];
		   id_variance = Unset;
		   id_sequence = -1;
		 }

    method get_name = ccsl_empty_fun_theory_name

    method get_parameters = [TypeParameter other_type_id]

    initializer top_theory#override_file_name ccsl_prelude_name

(* ISAR
 *     method get_proofs = []
 *)

    method private fundefn =
      let empty_type = TypeConstant(name_of_empty_type,Always,[]) in
      let other_type = BoundTypeVariable other_type_id in
      let empty_var = "z" in
      let other_var = "a" 
      in
	Defn(
	  name_of_empty_fun,
	  [],
	  (Function(empty_type, other_type)),
	  Abstraction(
	    [empty_var, empty_type],
	    Application(
	      Term("epsilon",Always,[]),
	      Abstraction(
		[other_var, other_type],
		Expression True))))
	

    method private singlefun =
      let proof = make_simple_proof [skosimp_star; extensionality] in
      let empty_type = TypeConstant(name_of_empty_type,Always,[]) in
      let other_type = BoundTypeVariable other_type_id in
      let other_f = "f" in
      let lem =
	Lemma(
	  name_of_unique_empty_fun_lemma,
	  Forall(
	    [other_f, Function(empty_type, other_type)],
	    Equal(
	      Term(other_f,Always,[]), 
		   Term(name_of_empty_fun, Always,[]))))
      in
	Proved( lem, PvsProof(Anon_proof proof))
	  

    method make_body = 
      [      
	Import( [ccsl_empty_type_defn_theory_name, []]);
	self#fundefn;
	self#singlefun
      ]

end (* ccsl_pre_empty_fun_theory *)

class ccsl_empty_fun_theory = 
  [ccsl_iface_type, ccsl_member_type] 
  ccsl_pre_empty_fun_theory
    empty_iface
    eq_ccsl_types



(***********************************************************************
 ***********************************************************************
 *
 * Isabelle part
 *
 * open close the prelude
 *)


class ccsl_isar_start_prelude =
  [ccsl_iface_type, ccsl_member_type] 
  ccsl_pre_isabelle_delimiter_theory_class
    empty_iface
    eq_ccsl_types
    IsabelleStartFile
    ccsl_prelude_name
    [isabelle_top_theory]
    true				(* do proofs *)

class ccsl_isar_close_prelude =
  [ccsl_iface_type, ccsl_member_type] 
  ccsl_pre_isabelle_delimiter_theory_class
    empty_iface
    eq_ccsl_types
    IsabelleCloseFile
    ccsl_prelude_name
    []
    true				(* do proofs *)

    
  
(***********************************************************************
 ***********************************************************************
 *
 * Isabelle part
 *
 * set2pred
 *)

class ['class_type, 'member_type] ccsl_pre_isabelle_addon_theory
  (cl : 'class_type) 
  (* the equality relation for initializing the name space *)
  (eq_types : ('class_type, 'member_type) top_pre_types
     -> ('class_type, 'member_type) top_pre_types -> bool)

  : ['class_type, 'member_type] ccsl_pre_sig_theory_type =
  object (self : 'self)

    inherit 
      ['class_type, 'member_type] ccsl_pre_sig_theory_class cl eq_types
      as top_theory

       (* reserve all names, that we want to declare *)
    initializer reserve ns 
      (
       [ name_of_set2pred;
       ]
      )

    val other_type_id = 
		 { id_token = { token_name = "A";
				loc = None };
		   (* the other fields are to ignored *)
		   id_type = Self;
		   id_origin = CCSL_TypeParameter;
		   id_parameters = [];
		   id_variance = Unset;
		   id_sequence = -1;
		 }
    method get_name = ccsl_isabelle_addon_theory_name

    method get_parameters = [TypeParameter other_type_id]

    initializer top_theory#override_file_name ccsl_prelude_name

    method private quick_and_dirty =
      [Comment("Enable quick_and_dirty for sorry proofs");
       IsarML "set quick_and_dirty";
      ]

    method private pred2set =
      let subns = sub_space ns in
      let a = BoundTypeVariable other_type_id in
      let a_name = other_type_id.id_token.token_name in
      let styp = TypeConstant("set", Always, [TypeArgument a]) in
      let s = create_id_with_preference subns "s" "s" in
      let x = create_id_with_preference subns "a" "a" in
      Defn(
	name_of_set2pred,
	[[Undeclared(s, styp); Undeclared(x,a)]],
	Bool,
	Term("( " ^ x ^ " : " ^ s ^ " )", Always, [])
      )

    method make_body = 
      self#quick_and_dirty
      @
      [      
	self#pred2set;
      ]

end (* ccsl_pre_empty_fun_theory *)

class ccsl_isabelle_addon_theory =
  [ccsl_iface_type, ccsl_member_type] 
  ccsl_pre_isabelle_addon_theory
    empty_iface
    eq_ccsl_types





(*** Local Variables: ***)
(*** version-control: t ***)
(*** kept-new-versions: 5 ***)
(*** delete-old-versions: t ***)
(*** time-stamp-line-limit: 30 ***)
(*** End: ***)


