;; 
;; The LOOP Project
;; 
;; The LOOP Team, Dresden University and Nijmegen University
;; 
;; Copyright (C) 2002
;; 
;; This program is free software; you can redistribute it and/or
;; modify it under the terms of the GNU General Public License as
;; published by the Free Software Foundation; either version 2 of
;; the License, or (at your option) any later version.
;; 
;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
;; General Public License in file COPYING in this or one of the
;; parent directories for more details.
;; 
;; Created by Hendrik
;; 
;; Time-stamp: <Monday 8 October 01 17:58:00 tews@ithif51>
;; 
;; emacs list script for producing the CCSL grammar 
;; user friendly version
;;
;; $Id: web.el,v 1.6 2002/09/18 15:35:06 tews Exp $
;; 

(setq revert-without-query '("grammar\\.txt" "tmp\\.buf" "raw\\.buf"))

(fset 'save-into-buf-a
   [?\C-x ?h ?\M-w ?\C-x ?b ?a ?\C-m ?\M-< ?\C-y ?\C-  ?\M-> ?\C-w ?\C-x ?b ?t ?m ?p ?. ?b ?u ?f ?\C-m])



(setq vc-handle-cvs nil)
(find-file "grammar.txt")
(erase-buffer)
(insert-file-contents "../Ccsl/grammar.mly")
(setq case-fold-search nil)
(setq delete-old-versions t)
(modify-syntax-entry ?_ "w")


; deleting everything but the grammar
(search-forward-regexp "^%%")
(forward-line)
(delete-region (point-min) (point))

(search-forward-regexp "^%%")
(forward-line -1)
(delete-region (point) (point-max))

;; do empty fields
(beginning-of-buffer)
(while (search-forward "/* empty */" nil t)
  (replace-match "(* EMPTY *)" t t))

;; do comments
(beginning-of-buffer)
(replace-regexp "/\\*[^/]*\\*/" "" nil)

;; do actions
(beginning-of-buffer)
(replace-regexp "{[^}]*}\\(
;\\)?" "")

;; do space
(beginning-of-buffer)
(while (search-forward-regexp "[ 	]+$" nil t)
  (replace-match "" nil t))

;; do %prec
(beginning-of-buffer)
(while (search-forward-regexp " %prec .*$" nil t)
  (replace-match "" nil t))

;(write-region (point-min) (point-max) "tmp.buf")

;(save-buffer)

;do empty lines in rules
(beginning-of-buffer)
(replace-regexp "^[ 	
]*
\\([ 	]*|\\)" "\\1")

;(write-region (point-min) (point-max) "raw.buf")

; define commands
(defun replace-meta (meta replace)
  (beginning-of-buffer)
  (search-forward-regexp (concat "^" meta ":"))
  (beginning-of-line)
  (let ((begin (point)))
    (search-forward-regexp "^[ 	]*$")
    (forward-line)
    (delete-region begin (point)))
  (beginning-of-buffer)
  (while (search-forward-regexp (concat "\\<" meta "\\>") nil t)
    (replace-match replace t t))
  )

; expand a metasymbol with its (one line) definition
(defun do-abbrev (meta)
  (beginning-of-buffer)
  (search-forward-regexp (concat "^" meta ":"))
  (forward-line)
  (let ((here (+ (point) 4))
	s)
    (search-forward-regexp "^[ 	]*$")
    (forward-line -1)
    (end-of-line)
    (setq s (buffer-substring here (point)))
    (replace-meta meta s)))

; rewrites a into { a } and changes
; a:
;     (* EMPTY *)
;  | a ....
; ->
; a:
;    { .... }
(defun do-iteration (meta)
  (beginning-of-buffer)
  (search-forward-regexp (concat "^" meta ":"))
  (beginning-of-line)
  (forward-line)
  (kill-line 1)
  (search-forward (concat "| " meta))
  (replace-match " ")
  (beginning-of-buffer)
  (while (search-forward-regexp (concat meta "\\([^:]\\)") nil t)
    (replace-match (concat "{ " meta " }\\1")))
  )

; changes
; a:
;     base case
;   | a iter case
; ->
; a:
;     base case { iter case }
(defun do-repetition (meta)
  (beginning-of-buffer)
  (search-forward-regexp (concat "^" meta ":"))
  (beginning-of-line)
  (search-forward (concat "| " meta))
  (replace-match "")
  (delete-indentation)
  (insert " {")
  (end-of-line)
  (search-forward-regexp " ?$")
  (replace-match " }")
  )

; rewrites a -> [ a ]
; changes
; a:
;     (* EMPTY *)
;   | some
; ->
; a:
;     some
(defun do-maybe (meta)
  (beginning-of-buffer)
  (search-forward-regexp (concat "^" meta ":"))
  (beginning-of-line)
  (forward-line)
  (kill-line 1)
  (search-forward "|")
  (replace-match " ")
  (beginning-of-buffer)
  (while (search-forward-regexp (concat meta "\\([^:]\\)") nil t)
    (replace-match (concat "[ " meta " ]\\1")))
  )

;renames
(defun rename-meta (old new)
  (beginning-of-buffer)
  (while (search-forward-regexp
	  (concat "\\<" old "\\>") nil t)
    (replace-match new t t))
  )

; introduces a new meta symbol and and changes all
; occurences of def into meta
(defun new-meta (after meta def)
  (let ((expdef (regexp-quote def))
	(expmeta (regexp-quote meta)))
    (beginning-of-buffer)
    (while (search-forward-regexp
	    (concat "\\(\\W\\)" expdef "\\(\\W\\)") nil t)
      (replace-match (concat "\\1" expmeta "\\2") t nil))
    (beginning-of-buffer)
    (search-forward-regexp (concat "^" after ":"))
    (beginning-of-line)
    (search-forward-regexp "^[ 	]*$")
    (forward-line)
    (insert meta ":\n" "    " def "\n\n")
    ))
  
;(save-buffer)

; formula:
;     PVS_FORMULA
;   | hol_formula SEMICOLON

(replace-meta "formula" "formula SEMICOLON")
(rename-meta "hol_formula" "formula")

;(write-region (point-min) (point-max) "tmp.buf")
;(save-buffer)


(do-iteration "declarationlist")


(do-abbrev "declarationlist")

;(write-region (point-min) (point-max) "tmp.buf")

(do-maybe "hol_formula_maybe")
(do-abbrev "hol_formula_maybe")

;(write-region (point-min) (point-max) "tmp.buf")

;(save-buffer)

; typekeyword:
;     GROUNDTYPE
;   | TYPE

(replace-meta "typekeyword" "TYPE")

; groundtermkeyword:
;     CONSTANT
;   | GROUNDTERM

(replace-meta "groundtermkeyword" "CONSTANT")

; pareninfix:
;     OPAREN INFIX_EXP CPAREN
;   | OPAREN INFIX_MUL CPAREN
;   | OPAREN INFIX_ADD CPAREN
;   | OPAREN INFIX_SHARP CPAREN
;   | OPAREN INFIX_REL CPAREN

(replace-meta "pareninfix" "pareninfix")
(new-meta "idorinfix" "pareninfix" "OPAREN infix_operator CPAREN")
(do-abbrev "pareninfix")

; termdefid:
;     ID
;   | pareninfix

(replace-meta "termdefid" "idorinfix")

(do-abbrev "termdefstart")

(do-maybe "typedefeq")
(do-abbrev "typedefeq")
(do-abbrev "typedefstart")

;(write-region (point-min) (point-max) "tmp.buf")


(do-abbrev "classstart")
(do-abbrev "datastart")

  
(do-maybe "renaming")
(do-maybe "visibility")
(do-maybe "instclass_maybe")
(do-maybe "assertionselfvar")
(do-maybe "adtaccessors")
(do-maybe "typeparameters")
(do-iteration "import_maybe")
(do-maybe "semicolon_maybe")
(do-iteration "varlist_maybe")
(do-maybe "semicolonorcomma_maybe")
(do-abbrev "semicolonorcomma_maybe")
(do-maybe "optvariance")
(do-maybe "finalorloose")
(do-abbrev "finalorloose")

;(save-buffer)

(rename-meta "typeparameters" "parameterlist")
(rename-meta "ID" "identifier")
(rename-meta "import_maybe" "importing")

;(write-region (point-min) (point-max) "tmp.buf")

; theory:
;     identifier
;   | identifier OBRACKET arglist CBRACKET

(replace-meta "theory" "theory")
(new-meta "importing" "theory" "identifier [ OBRACKET arglist CBRACKET ]")

(do-abbrev "theory")
(rename-meta "optvariance" "variance")

;(write-region (point-min) (point-max) "tmp.buf")

(replace-meta "classbody" "{ classsection }")

(do-repetition "paramdeclarations")
(do-abbrev "paramdeclarations")
(rename-meta "paramdeclaration" "parameters")


;(save-buffer)

(do-abbrev "semicolon_maybe")
(do-repetition "inheritsection")  

;(write-region (point-min) (point-max) "tmp.buf")

(new-meta "renamelist" "nrenaming" "identifier AS identifier")
(do-repetition "renamelist")

(new-meta "pvstypelist" "breckatarglist" "OBRACKET arglist CBRACKET")

;(write-region (point-min) (point-max) "tmp.buf")

;ancestor:
;    identifier [ renaming ]
;  | identifier breckatarglist [ renaming ]

(replace-meta "ancestor" "ancestor")

(new-meta "inheritsection" "ancestor"
	  "identifier [ breckatarglist ] [ renaming ]")


(do-abbrev "renamelist")
(do-abbrev "renaming")
(rename-meta "nrenaming" "renaming")

(do-repetition "arglist")
(do-abbrev "arglist")
(rename-meta "breckatarglist" "argumentlist")


; this screws up classconstructors
(new-meta "classconstructorsection" "member"
	  "identifier COLON pvstype")

;(write-region (point-min) (point-max) "tmp.buf")

; ; classconstructor:
; ;     identifier COLON pvstype
; ;   | member
; 
; (replace-meta "classconstructor" "classconstructor")
; (new-meta "classconstructorsection" "classconstructor"
; 	    "identifier COLON pvstype
;   | identifier COLON pvstype ARROW pvstype")
; 

;(write-region (point-min) (point-max) "tmp.buf")


(do-repetition "attributesection")
(do-repetition "methodsection")
(do-repetition "definitionsection")
(do-repetition "classconstructorsection")
(new-meta "theoremstart" "namedformula"
	  "identifier COLON formula SEMICOLON")
(do-repetition "assertionsection")
(do-abbrev "assertionstart")
(do-abbrev "classconstructor")

(rename-meta "varlist_maybe" "freevarlist")

;(save-buffer)

(do-repetition "creationsection")
(do-abbrev "creationstart")

;(write-region (point-min) (point-max) "tmp.buf")

;(save-buffer)

; requestsection:
;     REQUEST identifier COLON pvstype
;   | requestsection SEMICOLON identifier COLON pvstype

(replace-meta "requestsection" "requestsection")
(new-meta "namedformula" "requestsection"
	  (concat "REQUEST request { SEMICOLON request }\n\n"
		  "request:\n"
		  "    identifier COLON pvstype"))

;(write-region (point-min) (point-max) "tmp.buf")
;(save-buffer)

(do-abbrev "all_quant")
(do-abbrev "ex_quant")
(do-abbrev "lambda_quant")
(do-abbrev "hol_base")
(do-abbrev "type_annotation")

;   | formula OBSEQ formula
;   | formula EQUAL formula
;   | formula INFIX_REL formula
;   | formula INFIX_SHARP formula
;   | formula INFIX_ADD formula
;   | formula INFIX_MUL formula
;   | formula INFIX_EXP formula

(goto-char (point-min))
(let ((from "\
  | formula OBSEQ formula
  | formula EQUAL formula
  | formula INFIX_REL formula
  | formula INFIX_SHARP formula
  | formula INFIX_ADD formula
  | formula INFIX_MUL formula
  | formula INFIX_EXP formula")
      (to "  | formula infix_operator formula"))
  (search-forward from nil t)
  (replace-match to nil t))


;(write-region (point-min) (point-max) "tmp.buf")


(do-repetition "typedvarlist")
(do-abbrev "typedvarlist")

; instclass_maybe:
;     identifier DOUBLECOLON
;   | identifier argumentlist DOUBLECOLON

(replace-meta "instclass_maybe" "instclass_maybe")

(new-meta "update" "instclass_maybe"
	  "identifier [ argumentlist ] DOUBLECOLON")

(do-abbrev "instclass_maybe")


(new-meta "vardeclaration" "methodlist" "OBRACE idlist CBRACE")


;(write-region (point-min) (point-max) "tmp.buf")

; qualifiedid:
;     idorinfix
;   | identifier DOUBLECOLON idorinfix
;   | identifier argumentlist DOUBLECOLON idorinfix

(replace-meta "qualifiedid" "qualifiedid")
(new-meta "methodlist" "qualifiedid" "idorinfix
  | identifier [ argumentlist ] DOUBLECOLON idorinfix")

(do-repetition "vardeclarations")
(do-abbrev "vardeclarations")

;(write-region (point-min) (point-max) "tmp.buf")

; casepattern:
;     identifier
;   | identifier OPAREN idlist CPAREN

(replace-meta "casepattern" "casepattern")
(new-meta "caselist" "casepattern" "identifier [ OPAREN idlist CPAREN ]")
(rename-meta "casepattern" "pattern")

(do-repetition "idlist")
(do-abbrev "idlist")

(do-repetition "caselist")

(do-repetition "updatelist")
(do-abbrev "updatelist")

(do-abbrev "adtstart")

;(write-region (point-min) (point-max) "tmp.buf")

; adtbody:
;     adtfield
;   | adtbody adtfield
(replace-meta "adtbody" "{ adtfield }")
(rename-meta "adtfield" "adtsection")
(do-repetition "adtconstructorlist")

(rename-meta "pvstype" "type")
(rename-meta "pvstypelist" "typelist")

;(write-region (point-min) (point-max) "tmp.buf")

(do-repetition "typelist")
(do-abbrev "typelist")

(do-repetition "starproduct")
(do-abbrev "starproduct")
(replace-meta "star" "STAR")

(do-repetition "bindinglist")
(do-abbrev "bindinglist")

(do-repetition "hollist")
(do-abbrev "hollist")

;(write-region (point-min) (point-max) "tmp.buf")

(do-abbrev "signaturestart")

; signaturebody:
;     signaturesection
;   | signaturebody signaturesection
(replace-meta "signaturebody" "{ signaturesection }")
(do-repetition "signaturesymbolsection")

(do-abbrev "signaturetype")
(do-abbrev "signaturesymbol")

;(write-region (point-min) (point-max) "tmp.buf")

; binding:
;     identifier EQUAL formula
;   | identifier COLON type EQUAL formula

(replace-meta "binding" "binding")
(new-meta "idorinfix" "binding"
	  "identifier [ COLON type ] EQUAL formula")


;do theorems

(do-repetition "theoremsection")
(do-abbrev "theoremstart")

;(write-region (point-min) (point-max) "tmp.buf")

;do multiple empty lines
(beginning-of-buffer)
(while (search-forward-regexp "^\\([ 	]*\n\\)+" nil t)
  (replace-match "\n" t t))


;;;  txt version complete !!!
(save-buffer)


;;make things hot
(goto-char (point-min))
(while (re-search-forward " \\([a-z_]+\\)" nil t 1)
  (replace-match " <a href=\"#\\1\">\\1</a>"))
(goto-char (point-min))

;; mark positions
(while (re-search-forward "^\\(\\([a-z_]+\\):\\)" nil t 1)
  (replace-match "<a name=\"\\2\">\n\\1"))
(goto-char (point-min))

(setq hotgrammar (buffer-substring (point-min) (point-max)))

(setq load-path (append
		    (list (expand-file-name "~tews/lib/lisp/Fsf-20.5" ))
		    load-path))

(autoload 'html-helper-mode "html-helper-mode" "Yay HTML" t)
(setq auto-mode-alist (cons '("\\.html$" . html-helper-mode) auto-mode-alist))

;(add-hook 'tempo-insert-string-functions 'upcase)
(setq html-helper-address-string 
  "by <a href=\"/~tews\">Hendrik</a>")

;; "Thu Jun 26 18:03:02 1997"

(defun my-html-timestamp ()
  "My timestamp insertion function."
  (let ((time (current-time-string)))
    (insert (substring time 8 11)
	      (substring time 4 8)
	      (substring time 20 24)
	      "\n")))

(setq html-helper-timestamp-hook 'my-html-timestamp)


(find-file "grammar.html")
(erase-buffer)
(insert-file-contents "userskel.html")
(beginning-of-buffer)

(search-forward "<pre>")
(forward-line 1)
(insert hotgrammar)

(save-buffer)


;;; Local Variables: ***
;;; version-control: t ***
;;; kept-new-versions: 5 ***
;;; delete-old-versions: t ***
;;; time-stamp-line-limit: 30 ***
;;; End: ***

