(*
 * The LOOP Project
 *
 * The LOOP Team, Dresden University and Nijmegen University
 *
 * Copyright (C) 2002
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License in file COPYING in this or one of the
 * parent directories for more details.
 *
 * Adopted 25.1.99 by Hendrik
 *
 * Time-stamp: <Monday 8 October 01 17:58:00 tews@ithif51>
 *
 * Lexic for the declaration part of ocamlyacc
 *
 * $Id: yacc_lexer.mll,v 1.4 2002/05/03 15:01:21 tews Exp $
 *
 *)

{
  open Yacc_grammar;;
  open Lexing;;

  let d s =
    if !Global.debug
    then  begin
      prerr_string( "SHIFT " ^ s ^ "\n" );
      flush stderr
    end;;
}

let identifier = ['a'-'z' 'A'-'Z' '_' '.']+
let whitespace = [' ' '\t']

rule yacc =
  parse
      whitespace		{ yacc lexbuf }	(* skip blanks *)
    | '\n'			{ d "Eol"; incr Global.line; yacc lexbuf}
    | "%{"			{ d "Header"; header lexbuf }
    | "/* KEYWORD"		{ d "Keyword"; KEYWORD }
    | "/*"			{ d "Begin Comment"; comment lexbuf }
    | "*/"			{ d "End Comment"; yacc lexbuf }
    | "%token"			{ d "Token"; TOKEN }
    | "%start"			{ d "Start"; START }
    | "%type"			{ d "Type"; TYPE }
    | "%left"			{ d "Left"; LEFT }
    | "%right"			{ d "Right"; RIGHT }
    | "%nonassoc"		{ d "Assoc"; ASSOC }
    | '<'			{ d "Type"; typedec lexbuf }
    | identifier		{ d ("Symbol " ^ lexeme lexbuf);
				  SYMBOL (lexeme lexbuf) }
    | '\\' identifier		{ d ("Symbol " ^ lexeme lexbuf);
				  SYMBOL ("\\" ^ lexeme lexbuf) }
    | identifier ':'		{ d ("Symbol " ^ lexeme lexbuf);
				  SYMBOL (lexeme lexbuf) }
    | '!' identifier 		{ d ("Symbol " ^ lexeme lexbuf);
				  SYMBOL (lexeme lexbuf) }
    | '(' whitespace* 
       (identifier | '!' identifier) whitespace*
       ("&&" whitespace* (identifier | '!' identifier))*
       whitespace*
      ')'
	                        { d ("Symbol " ^ lexeme lexbuf);
				  SYMBOL (lexeme lexbuf) }
    | "%%"			{ d "Eod"; EOD }

and header =
  parse
      ( [^'%']* ('%'[^'}'])? )* "%}"	{ HEADER }

and typedec =
  parse
      [^'>']* '>'		{ let t = lexeme lexbuf in
				  let t' = String.sub t 0 
					     ((String.length t) -1)
				  in
				    TYPEDEC t' }

and comment =
  parse
      [' ' '\t']			{ comment lexbuf } (* skip blanks *)
    | ( [^'*']* ('*'[^'/'])? )*		{ d "Nix"; yacc lexbuf }

(*** Local Variables: ***)
(*** version-control: t ***)
(*** kept-new-versions: 5 ***)
(*** delete-old-versions: t ***)
(*** time-stamp-line-limit: 30 ***)
(*** End: ***)
