(*
 * The LOOP Project
 *
 * The LOOP Team, Dresden University and Nijmegen University
 *
 * Copyright (C) 2002
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License in file COPYING in this or one of the
 * parent directories for more details.
 *
 * Created 25.6.99 by Hendrik
 *
 * Time-stamp: <Monday 8 October 01 17:58:00 tews@ithif51>
 *
 * Substitution and class instanciation
 *
 * $Id: substitution.mli,v 1.4 2002-05-03 15:01:14 tews Exp $
 *
 *)

open Top_variant_types
open Classtypes;;


(*****************************
 * class instanciation
 * 
 * takes the class to instanciate and a argument list
 *
 * class instanciation does only the minimal neccessary job, the 
 * instanciated class contains only (instanciated) ancestors, 
 * members and components
 * 
 * all other access methods are blocked
 *)

(* make a deep clone of the class and method structure and instanciate 
 * the class and all its ancestors
 * the clone contains only those members that pass the method filter
 * 
 * its an internal error to use a method filter that treats attributes 
 * and their update methods different
 *)

val instanciate : ccsl_iface_type -> ccsl_argument_type list -> 
  (ccsl_member_type -> bool) -> ccsl_iface_type


(* 
 * For ccsl instanciated classes and adt's can be stored in the 
 * symboltable. The overloading feature of the symboltable is used 
 * to distinguish between different instanciations of the same class. 
 * Instanciated classes are stored in their own name space: InstIface. 
 * Special care must be taken to store a new instanciation in the 
 * *same* scope, where the original class or adt is found. 
 * Storing instanciations makes sense for component classes. It makes 
 * no sense for inherited classes, because of possible renamings.
 * 
 * In 
 * 
 *   find_instanciated_iface iface arg_list
 * 
 * iface is a class or an adt. The arg_list must be of the right shape 
 * for the class. The result is an instanciate class or adt, if it not 
 * exists yet, it is generated on the fly.
 * As method filter (fun _ -> true) is used, that is, no methods are 
 * hidden when an iface is instanciated in find_instanciated_iface.
 *)

val find_instanciated_iface : 
  ccsl_iface_type -> ccsl_argument_type list -> ccsl_iface_type





(*** Local Variables: ***)
(*** version-control: t ***)
(*** kept-new-versions: 5 ***)
(*** delete-old-versions: t ***)
(*** time-stamp-line-limit: 30 ***)
(*** End: ***)

