(* 
 * Formalized Cut Elimination in Coalgebraic Logics
 * 
 * Copyright (C) 2013 - 2013 Hendrik Tews
 * 
 * This file is part of my formalization of "Cut Elimination in 
 * Coalgebraic Logics" by Dirk Pattinson and Lutz Schroeder.
 * 
 * The formalization is free software: you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * The formalization is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License in file COPYING in this or one of the parent
 * directories for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with the formalization in the file COPYING. 
 * If not, see <http://www.gnu.org/licenses/>.
 * 
 * $Id: cast.v,v 1.4 2013/04/10 11:17:14 tews Exp $
 *)

(** ** Coq casts for function domains and codomains and results 

      With dependent types it may happen, that a theorem of the form
      [a = b] does not type-check, because you can only prove that the
      types of [a] and [b] are equal and the type checker does not see
      this equality. The workaround is to rewrite the type of [a] into
      the type of [b] (or vice versa), using the proven equality. On
      the term level this rewriting is done with a dependent pattern
      match on the equality proof. 

      Because these pattern matches are a bit verbose, I define here
      the casts that I need.
*)

Definition fun_dom_cast{X Y Z : Type}(eq : X = Y)(f : X -> Z) : Y -> Z :=
  match eq in _ = Y' return Y' -> Z with
    | eq_refl => f
  end.

Lemma dom_map_cast :
  forall(X Y Z : Type)(T : Type -> Type)
        (TM : forall(A B : Type), (A -> B) -> (T A -> T B))
        (eq_lift : forall(A B : Type), A = B -> T A = T B)
        (eq : X = Y)(f : X -> Z),
    (forall(A : Type), eq_lift A A eq_refl = eq_refl) ->
      TM Y Z (fun_dom_cast eq f) = 
      fun_dom_cast (eq_lift X Y eq) (TM X Z f).
Proof.
  intros X Y Z T TM eq_lift eq f H.
  rewrite <- eq.
  rewrite H.
  trivial.
Qed.

Definition fun_codom_cast{X Y Z : Type}(eq : Y = Z)(f : X -> Y) : X -> Z :=
  match eq in _ = Z' return X -> Z' with
    | eq_refl => f
  end.

Lemma codom_map_cast :
  forall(X Y Z : Type)(T : Type -> Type)
        (TM : forall(A B : Type), (A -> B) -> (T A -> T B))
        (eq_lift : forall(A B : Type), A = B -> T A = T B)
        (eq : Y = Z)(f : X -> Y),
    (forall(A : Type), eq_lift A A eq_refl = eq_refl) ->
      TM X Z (fun_codom_cast eq f) = 
      fun_codom_cast (eq_lift Y Z eq) (TM X Y f).
Proof.
  intros X Y Z T TM eq_lift eq f H.
  rewrite <- eq.
  rewrite H.
  trivial.
Qed.

