(* 
 * Formalized Cut Elimination in Coalgebraic Logics
 * 
 * Copyright (C) 2013 - 2013 Hendrik Tews
 * 
 * This file is part of my formalization of "Cut Elimination in 
 * Coalgebraic Logics" by Dirk Pattinson and Lutz Schroeder.
 * 
 * The formalization is free software: you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * The formalization is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License in file COPYING in this or one of the parent
 * directories for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with the formalization in the file COPYING. 
 * If not, see <http://www.gnu.org/licenses/>.
 * 
 * $Id: ck.v,v 1.8 2013/04/10 11:17:14 tews Exp $
 *)


(** * Other material *)

(** ** CK example, 2.2.ii

      This module defines (only) the functor for CK. Proving the
      functor properties requires extentionality of functions and
      predicates. 
 *)

Require Export functor image.

Section CK.

  Hypothesis fun_ext : forall(A B : Type)(f g : A -> B),
    (forall(a : A), f a = g a) -> f = g.

  Hypothesis pred_ext : forall(A : Type)(P Q : A -> Prop),
   (forall(a : A), P a <-> Q a) -> P = Q.

  (* CK functor, example 2.2.ii, page 9 *)
  Definition ck_functor : functor.
  Proof.
    refine {| obj := fun(X : Type) => set X -> set X;
              fmap := fun(X Y : Type)(f : X -> Y)(xo : set X -> set X)
                        (ys : set Y) =>
                      direct_img f (xo (inv_img f ys));
              id_law := _;
              comp_law := _;
              fmap_feq_law := _
           |}.
        intros X x.
        apply fun_ext.
        intros a.
        apply pred_ext.
        intros a0.
        cbv.
        split.
          intros H.
          decompose [ex and or] H; clear H.
          subst x0.
          trivial.
        intros H.
        exists a0.
        split.
          trivial.
        trivial.
      intros X Y Z f g x.
      apply fun_ext.
      intros a.
      apply pred_ext.
      intros a0.
      cbv.
      split.
        intros H.
        decompose [ex and or] H; clear H.
        exists (f x0).
        split.
          trivial.
        exists x0.
        split.
          trivial.
        trivial.
      intros H.
      decompose [ex and or] H; clear H.
      exists x1.
      split.
        rewrite H2.
        trivial.
      trivial.
    intros X Y f1 f2 H FX.
    apply fun_ext.
    intros ys.
    apply pred_ext.
    intros y.
    apply feq_direct_img.
      trivial.
    rewrite (pred_ext _ (inv_img f1 ys) (inv_img f2 ys)).
      apply set_equal_refl.
    apply set_equal_inv_img_feq.
    trivial.
  Qed.

End CK.

