(* 
 * Formalized Cut Elimination in Coalgebraic Logics
 * 
 * Copyright (C) 2013 - 2013 Hendrik Tews
 * 
 * This file is part of my formalization of "Cut Elimination in 
 * Coalgebraic Logics" by Dirk Pattinson and Lutz Schroeder.
 * 
 * The formalization is free software: you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * The formalization is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License in file COPYING in this or one of the parent
 * directories for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with the formalization in the file COPYING. 
 * If not, see <http://www.gnu.org/licenses/>.
 * 
 * $Id: contraction.v,v 1.9 2013/04/10 11:17:14 tews Exp $
 *)


(** ** Admissibility of contraction, 5.6.2

      This module proves the induction step for the admissibility of
      contraction in GR_n (5.6.2). The Lemma for this induction step
      is only about contraction in head position. There is also a
      Lemma that lifts this head contruction result to general
      admissibility of contraction. 
*)

Require Export absorb.

Section Contraction_ind.

  Variable V : Type.
  Variable L : modal_operators.

  Variable op_eq : eq_type (operator L).
  Variable v_eq : eq_type V.


  (***************************************************************************)
  (** ***  Induction step for contraction
          used in a mutal induction with cut elimination, see 5.6, page 28 *)
  (***************************************************************************)

  Lemma provable_assumptions_contraction_rule :
    forall(rules : set (sequent_rule V L))(n : nat)
          (r cr : sequent_rule V L)
          (sigma inj_sigma rsigma rho : lambda_subst V L),
      countably_infinite V ->
      one_step_rule_set rules ->
      absorbs_congruence rules ->
      rules r ->
      rules cr ->
      rank_subst (S n) inj_sigma ->
      renaming rsigma ->
      renaming rho ->
      subst_eq_on_vars sigma (subst_compose inj_sigma rsigma)
                       (prop_var_sequent (conclusion r)) ->
      (forall(s : sequent V L),
         provable (GRC_n_set rules (S n)) (empty_sequent_set V L) s ->
           provable (GR_n_set rules (S n)) (empty_sequent_set V L) s) ->
      every_nth
        (provable (GR_n_set rules (S n)) (empty_sequent_set V L))
        (map (subst_sequent sigma) (assumptions r)) ->
      every_nth
        (fun ca : sequent V L =>
           provable (GC_n_set V L 1)
             (reordered_sequent_list_set 
                        (map (subst_sequent rsigma) (assumptions r)))
             (subst_sequent rho ca))
        (assumptions cr)
      ->
        every_nth (provable (GR_n_set rules (S n)) (empty_sequent_set V L))
          (map (subst_sequent (subst_compose inj_sigma rho)) (assumptions cr)).
  Proof.
    intros rules n r cr sigma inj_sigma rsigma rho 
           H H0 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10.
    apply every_nth_map.
    intros i i_less.
    specialize (H10 i i_less).
    simpl in H10.
    rewrite subst_sequent_compose.
    apply proof_mono_rules with (rules2 := (GRC_n_set rules 1)) in H10.
      eapply GRC_n_substitution_lemma with (sigma := inj_sigma) in H10; eauto.
        apply H8.
        apply plug_empty_hypothesis_proof with (2 := H10).
        clear - v_eq H H0 H1 H2 H3 H4 H5 H7 H9.
        intros h H6.
        destruct H6.
          eapply proof_mono_rules.
            apply GR_n_subset_GRC_n.
          apply syntactic_GR_n_provable_subst_Ax 
                 with (1 := v_eq)(sigma := inj_sigma); trivial.
        unfold subst_sequent_set, reordered_sequent_list_set in *.
        decompose [ex and] H6; clear H6.
        rename x into s1, x0 into s2.
        subst h.
        eapply provable_GRC_n_list_reorder.
          apply list_reorder_symm.
          apply list_reorder_subst_sequent.
          eexact H10.
        apply in_map_iff in H12.
        decompose [ex and] H12; clear H12.
        rename x into s3.
        subst s2.
        rewrite <- subst_sequent_compose.
        rewrite <- subst_sequent_eq with (2 := H7).
          eapply proof_mono_rules.
            apply GR_n_subset_GRC_n.
          eapply every_nth_In.
            eexact H9.
          apply in_map.
          trivial.
        lapply (one_step_rule_incl_prop_var_sequent r).
          intros H6.
          eapply every_nth_In with (1 := H6).
          trivial.
        apply H0.
        trivial.
      clear - H0 H2 H5.
      apply rank_sequent_set_sequent_list_set.
      apply rank_subst_assumptions.
        auto.
      apply rank_renaming.
      trivial.
    apply GC_n_subset_GRC_n.
  Qed.

  Lemma head_contraction_closed_provable_subst_n_conclusions_ind :
    forall(rules : set (sequent_rule V L))(n : nat),
      countably_infinite V ->
      one_step_rule_set rules ->
      absorbs_congruence rules ->
      absorbs_contraction op_eq v_eq rules ->
      (forall(s : sequent V L),
              provable (GRC_n_set rules (S n)) (empty_sequent_set V L) s ->
                provable (GR_n_set rules (S n)) (empty_sequent_set V L) s) ->
        head_contraction_closed 
          (provable_subst_n_conclusions rules (2 + n) (lt_0_Sn (S n))).
  Proof.
    unfold head_contraction_closed in *.
    intros rules n H H0 H1 H2 H3 f s H4.
    unfold provable_subst_n_conclusions in *.
    unfold rank_weaken_subst_rule in H4.
    decompose [ex and] H4; clear H4.
    rename x into r, x0 into rbase, x1 into sigma, x2 into delta.
    rewrite <- H10 in *.
    decompose [ex or and] (list_reorder_double_append _ _ _ _ H11).
        rename x into cbrtl.
        decompose [ex and] (factor_subst_property op_eq v_eq sigma
                               (conclusion rbase) _ H5).
        rename x into rsigma, x0 into inj_sigma.
        lapply (list_reorder_right_map (subst_form inj_sigma) (f :: f :: cbrtl)
                             (subst_sequent rsigma (conclusion rbase))).
          intros H15.
          decompose [ex and] H15; clear H15.
          rename x into conc_rbas_reord.
          destruct conc_rbas_reord.
            discriminate.
          destruct conc_rbas_reord.
            discriminate.
          simpl in H18.
          inversion H18; clear H18.
          apply injective_subst_neg_simple_modal in H20; trivial.
              subst l0.
              assert (H22 := absorbs_contraction_head op_eq v_eq
                             _ _ _ _ _ H0 H2 H6 H4 H19).
              clear H2.
              decompose [ex and] H22; clear H22.
              rename x into cr, x0 into rho, x1 into cr_delta.
              exists 
                {| assumptions := 
                     map (subst_sequent (subst_compose inj_sigma rho))
                         (assumptions cr);
                   conclusion := f :: s |}.
              simpl.
              split.
                exists cr, (subst_compose inj_sigma rho), 
                           (subst_sequent inj_sigma cr_delta ++ delta).
                simpl.
                split; trivial.
                split.
                  eapply rank_subst_subst_compose.
                      eexact H14.
                    apply rank_renaming.
                    trivial.
                  rewrite plus_0_r.
                  trivial.
                split.
                  apply rank_sequent_append.
                    eapply rank_sequent_subst_add.
                          apply rank_simple_modal_sequent.
                          trivial.
                        eexact H14.
                      apply le_n_S.
                      apply le_0_n.
                    trivial.
                  trivial.
                split; trivial.
                clear - H0 H11 H7 H16 H17 H19 H20.
                rewrite subst_sequent_compose.
                apply list_reorder_tail_head with (a := f).
                eapply list_reorder_trans.
                  eexact H11.
                rewrite app_comm_cons.
                rewrite app_assoc.
                apply list_reorder_append_right.
                rewrite subst_sequent_eq with (2 := H16).
                  clear H11 H16.
                  rewrite subst_sequent_compose.
                  subst f.
                  change (subst_form inj_sigma l :: 
                              subst_sequent inj_sigma 
                                  (subst_sequent rho (conclusion cr)))
                    with (subst_sequent inj_sigma 
                               (l :: (subst_sequent rho (conclusion cr)))).
                  rewrite <- subst_sequent_append.
                  apply list_reorder_subst_sequent.
                  eapply list_reorder_trans.
                    apply list_reorder_symm.
                    eexact H19.
                  simpl.
                  apply list_reorder_cons_head.
                  trivial.
                apply incl_refl.
              split.
                subst f.
                trivial.
              apply (provable_assumptions_contraction_rule 
                           _ _ rbase _ sigma _ rsigma); trivial.
              rewrite <- H9.
              trivial.
            eapply simple_modal_sequent_head.
            eapply one_step_rule_simple_modal_conclusion_subst_reorder; eauto.
          eapply simple_modal_sequent_head.
          eapply simple_modal_sequent_tail.
          eapply one_step_rule_simple_modal_conclusion_subst_reorder; eauto.
        apply subst_sequent_eq with (s := (conclusion rbase)) in H16.
          rewrite subst_sequent_compose in H16.
          unfold subst_sequent at 2 in H16.
          rewrite <- H16.
          trivial.
        apply incl_refl.
      rename x into cbrtl, x0 into delta_tl.
      exists {| assumptions := assumptions r; conclusion := f :: s |}.
      split.
        exists rbase, sigma, delta_tl.
        repeat split; trivial.
          eapply rank_sequent_tail.
          eapply rank_sequent_list_reorder.
            eexact H13.
          trivial.
        simpl.
        apply list_reorder_tail with (a := f).
        eapply list_reorder_trans.
          eexact H11.
        apply list_reorder_append_left.
        apply list_reorder_symm.
        trivial.
      auto.
    rename x into delta_tl.
    exists {| assumptions := assumptions r; conclusion := f :: s |}.
    split.
      exists rbase, sigma, (f :: delta_tl).
      repeat split; trivial.
        eapply rank_sequent_tail.
        eapply rank_sequent_list_reorder.
          eexact H4.
        trivial.
      simpl.
      apply list_reorder_tail with (a := f).
      eapply list_reorder_trans.
        eexact H11.
      apply list_reorder_append_left.
      apply list_reorder_symm.
      trivial.
    auto.
  Qed.

  Lemma syntactic_GR_n_contraction_ind :
    forall(rules : set (sequent_rule V L))(n : nat)
          (s : sequent V L)(f : lambda_formula V L),
      countably_infinite V ->
      one_step_rule_set rules ->
      absorbs_congruence rules ->
      absorbs_contraction op_eq v_eq rules ->
      (forall(s : sequent V L),
         provable (GRC_n_set rules (S n)) (empty_sequent_set V L) s ->
           provable (GR_n_set rules (S n)) (empty_sequent_set V L) s) ->
      provable (GR_n_set rules (2 + n)) (empty_sequent_set V L) 
               (f :: f :: s) ->
        provable (GR_n_set rules (2 + n)) (empty_sequent_set V L) (f :: s).
  Proof.
    intros rules n s f H H0 H1 H2 H3 H4.
    apply countably_infinite_non_empty with (X := V); trivial.
    intros nonempty_v.
    (* 
     * assert (rank_sequent (2 + n) (f :: s)).
     *   apply rank_sequent_cons; trivial.
     *)
    rewrite GR_n_provable_with_premises 
            with (npos := lt_0_Sn (S n)) (1 := v_eq);
            trivial.
    apply G_n_contraction_head; trivial.
          apply multiset_provable_subst_n_conclusions.
        apply head_inversion_provable_subst_n_conclusion.
        trivial.
      apply head_contraction_closed_provable_subst_n_conclusions_ind; trivial.
    rewrite <- GR_n_provable_with_premises; trivial.
  Qed.


  (***************************************************************************)
  (** ***  Lift head contraction to sequent_support  *)
  (***************************************************************************)

  Lemma syntactic_support_contraction_ind :
    forall(rules : set (sequent_rule V L))(n : nat)(s1 s2 : sequent V L),
      (forall(s : sequent V L)(f : lambda_formula V L),
         provable (GR_n_set rules n) (empty_sequent_set V L)
                  (f :: f :: s) ->
           provable (GR_n_set rules n) (empty_sequent_set V L) 
                    (f :: s)) ->
      provable (GR_n_set rules n) (empty_sequent_set V L) (s1 ++ s2) ->
      incl s1 s2 ->
        provable (GR_n_set rules n) (empty_sequent_set V L) s2.
  Proof.
    induction s1.
      intros s2 H H0 H1.
      trivial.
    rename a into f.
    intros s2 H H0 H1.
    apply IHs1.
        trivial.
      clear IHs1.
      lapply (H1 f); clear H1.
        intros H1.
        apply list_reorder_In_split in H1.
        decompose [ex] H1; clear H1.
        rename x into s2l, x0 into s2r.
        eapply provable_GR_n_list_reorder.
          apply list_reorder_symm.
          eapply list_reorder_trans.
            apply list_reorder_append_left.
            eexact H3.
          apply list_reorder_symm.
          apply list_reorder_move_append.
        apply H.
        clear H.
        eapply provable_GR_n_list_reorder.
          apply list_reorder_cons_head.
          apply list_reorder_symm.
          eapply list_reorder_trans.
            apply list_reorder_cons_parts.
            apply list_reorder_refl.
          apply list_reorder_append_left.
          apply list_reorder_symm.
          eexact H3.
        trivial.
      left.
      trivial.
    apply incl_left_tail in H1.
    trivial.
  Qed.

  Lemma syntactic_support_contraction :
    forall(rules : set (sequent_rule V L))(n : nat)(s : sequent V L),
      (forall(s : sequent V L)(f : lambda_formula V L),
         provable (GR_n_set rules n) (empty_sequent_set V L)
                  (f :: f :: s) ->
           provable (GR_n_set rules n) (empty_sequent_set V L) 
                    (f :: s)) ->
      provable (GR_n_set rules n) (empty_sequent_set V L) s ->
        provable (GR_n_set rules n) (empty_sequent_set V L) 
                 (sequent_support op_eq v_eq s).
  Proof.
    intros rules n s H H0.
    destruct (sequent_support_destruct op_eq v_eq s) as [s'].
    destruct H1.
    apply provable_GR_n_list_reorder with (1 := H1) in H0.
    eapply syntactic_support_contraction_ind; eauto.
  Qed.

End Contraction_ind.
