(* 
 * Formalized Cut Elimination in Coalgebraic Logics
 * 
 * Copyright (C) 2013 - 2013 Hendrik Tews
 * 
 * This file is part of my formalization of "Cut Elimination in 
 * Coalgebraic Logics" by Dirk Pattinson and Lutz Schroeder.
 * 
 * The formalization is free software: you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * The formalization is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License in file COPYING in this or one of the parent
 * directories for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with the formalization in the file COPYING. 
 * If not, see <http://www.gnu.org/licenses/>.
 * 
 * $Id: osr_cut.v,v 1.11 2013/04/10 11:17:15 tews Exp $
 *)

(** ** Cut elimination case a, part of 5.6.3

      This module contains the proof for case a) for the induction
      step of cut eliminations in 5.6. Case a) is the case of a cut
      between two one-step rules.

      For case a) 1, i.e., the cut formula is in the weakening context
      of one of the one-step rules, see generic_cut.v 
 *)

Require Export contraction factor_two_subst.


Section OSR_cut.

  Variable V : Type.
  Variable L : modal_operators.

  Variable op_eq : eq_type (operator L).
  Variable v_eq : eq_type V.


  (***************************************************************************)
  (** *** Case a 2: both cut formulas are in the one-step rule *)
  (***************************************************************************)

  Lemma syntactic_GR_n_get_cut_rule :
    forall(rules : set (sequent_rule V L))(n : nat)
          (fsub : lambda_formula V L)
          (rb_l rb_r : sequent_rule V L)(sigma_l sigma_r : lambda_subst V L)
          (concl_l_subst concl_r_subst : sequent V L),
      countably_infinite V ->
      one_step_rule_set rules ->
      absorbs_cut op_eq v_eq rules ->
      rules rb_l -> rules rb_r ->
      rank_subst (S n) sigma_l -> rank_subst (S n) sigma_r ->
      list_reorder (fsub :: concl_l_subst)
                   (subst_sequent sigma_l (conclusion rb_l)) ->
      list_reorder ((lf_neg fsub) :: concl_r_subst)
                   (subst_sequent sigma_r (conclusion rb_r))
      ->
        exists(rsigma_l rsigma_r inj_sigma cut_sigma : lambda_subst V L)
              (cut_r : sequent_rule V L)(concl_l concl_r : sequent V L),
          renaming rsigma_l /\ renaming rsigma_r /\ 
          renaming cut_sigma /\ rank_subst (S n) inj_sigma /\ 
          injective inj_sigma /\
          rules cut_r /\
          rank_sequent 2 concl_l /\ rank_sequent 2 concl_r /\
          concl_l_subst = subst_sequent inj_sigma concl_l /\
          concl_r_subst = subst_sequent inj_sigma concl_r /\
          map (subst_sequent sigma_l) (assumptions rb_l) =
            map (subst_sequent (subst_compose inj_sigma rsigma_l))
                (assumptions rb_l) /\
          map (subst_sequent sigma_r) (assumptions rb_r) =
            map (subst_sequent (subst_compose inj_sigma rsigma_r))
                (assumptions rb_r) /\
          multi_subset
            (sequent_support op_eq v_eq 
                     (subst_sequent cut_sigma (conclusion cut_r)))
            (concl_l ++ concl_r) /\
          every_nth
            (fun ass => 
               provable (GC_n_set V L 1)
                        (reordered_sequent_list_set
                           ((map (subst_sequent rsigma_l) (assumptions rb_l)) ++
                            (map (subst_sequent rsigma_r) (assumptions rb_r))))
                 (subst_sequent cut_sigma ass))
            (assumptions cut_r).
  Proof.
    intros rules n fsub rb_l rb_r sigma_l sigma_r concl_l_subst 
           concl_r_subst H H0 H1 H2 H3 H4 H5 H6 H7.
    decompose [ex and] (factor_two_subst_property op_eq v_eq _ _ 
                           (conclusion rb_l) (conclusion rb_r) _ 
                           H H4 H5).
    rename x into rsigma_l, x0 into rsigma_r, x1 into inj_sigma.
    lapply (list_reorder_right_map (subst_form inj_sigma) 
                (fsub :: concl_l_subst) 
                (subst_sequent rsigma_l (conclusion rb_l))).
      intros H13.
      decompose [ex and] H13; clear H13.
      rename x into concl_l.
      destruct concl_l as [| f].
        discriminate.
      simpl in H16.
      inversion H16; clear H16.
      lapply (list_reorder_right_map (subst_form inj_sigma) 
                   ((lf_neg fsub) :: concl_r_subst) 
                   (subst_sequent rsigma_r (conclusion rb_r))).
        intros H13.
        decompose [ex and] H13; clear H13.
        rename x into concl_r.
        destruct concl_r as [| negf].
          discriminate.
        simpl in H19.
        inversion H19; clear H19.
        assert (neg_form_maybe simple_modal_form negf).
          eapply simple_modal_sequent_head.
          eapply one_step_rule_simple_modal_conclusion_subst_reorder; eauto.
        destruct negf; try contradiction.
          rewrite subst_form_char in H16.
          inversion H16; clear H16.
          lapply (injective_subst_neg_simple_modal _ f negf H10).
            intros H16; lapply H16; clear H16.
              intros H16; lapply H16; clear H16.
                intros H16.
                subst negf.
                assert (H23 := list_reorder_first_occurence _ _ _ H17).
                assert (H24 := list_reorder_first_occurence _ _ _ H20).
                decompose [ex and or dep_and] H23; clear H23.
                rename x into nl, a into nl_less.
                decompose [ex and or dep_and] H24; clear H24.
                rename x into nr, a into nr_less.
                rewrite <- H16 in H23.
                apply eq_sym in H23.
                apply H1 in H23; trivial.
                decompose [ex and] H23; clear H23.
                rename x into cut_r, x0 into cut_sigma.
                exists rsigma_l, rsigma_r, inj_sigma, cut_sigma, cut_r, 
                       concl_l, concl_r.
                split; trivial.
                split; trivial.
                split; trivial.
                split; trivial.
                split; trivial.
                split; trivial.
                split.
                  clear - H0 H2 H9 H17.
                  eapply rank_sequent_tail.
                  eapply rank_sequent_list_reorder.
                    eexact H17.
                  apply rank_subst_conclusion; eauto.
                  apply rank_renaming.
                  trivial.
                split.
                  clear - H0 H3 H8 H20.
                  eapply rank_sequent_tail.
                  eapply rank_sequent_list_reorder.
                    eexact H20.
                  apply rank_subst_conclusion; eauto.
                  apply rank_renaming.
                  trivial.
                split; trivial.
                split; trivial.
                split.
                  clear - H0 H2 H12.
                  apply restricted_map_ext.
                  intros i i_less.
                  eapply subst_sequent_eq.
                    apply one_step_rule_incl_prop_var_sequent.
                    auto.
                  trivial.
                split.
                  clear - H0 H3 H14.
                  apply restricted_map_ext.
                  intros i i_less.
                  eapply subst_sequent_eq.
                    apply one_step_rule_incl_prop_var_sequent.
                    auto.
                  trivial.
                split; trivial.
                clear - H19 H25 H27.
                unfold multi_subset in *.
                destruct H27 as [delta].
                exists delta.
                eapply list_reorder_trans.
                  eexact H.
                apply list_reorder_append_both.
                  apply list_reorder_symm.
                  trivial.
                apply list_reorder_symm.
                trivial.
              rewrite <- H15.
              rewrite <- H22.
              trivial.
            clear - H13.
            simpl in *.
            destruct negf; try contradiction; trivial.
          clear - H0 H2 H9 H17.
          eapply simple_modal_sequent_head.
          eapply one_step_rule_simple_modal_conclusion_subst_reorder; eauto.
        rewrite subst_form_char in H16.
        discriminate.
      apply subst_sequent_eq with (s := (conclusion rb_r)) in H14.
        rewrite subst_sequent_compose in H14.
        unfold subst_sequent at 2 in H14.
        rewrite <- H14.
        trivial.
      apply incl_refl.
    apply subst_sequent_eq with (s := (conclusion rb_l)) in H12.
      rewrite subst_sequent_compose in H12.
      unfold subst_sequent at 2 in H12.
      rewrite <- H12.
      trivial.
    apply incl_refl.
  Qed.


  Lemma syntactic_GR_n_prove_cut_absorb_assumptions :
    forall(rules : set (sequent_rule V L))(n : nat)
          (rb_l rb_r cut_r : sequent_rule V L)
          (rsigma_l rsigma_r inj_sigma cut_sigma : lambda_subst V L),
      countably_infinite V ->
      one_step_rule_set rules ->
      absorbs_congruence rules ->
      rules rb_l -> rules rb_r ->
      renaming rsigma_l -> renaming rsigma_r -> renaming cut_sigma ->
      rank_subst (S n) inj_sigma ->
      every_nth (provable (GR_n_set rules (S n)) (empty_sequent_set V L))
        (map (subst_sequent (subst_compose inj_sigma rsigma_l)) 
             (assumptions rb_l)) ->
      every_nth (provable (GR_n_set rules (S n)) (empty_sequent_set V L))
        (map (subst_sequent (subst_compose inj_sigma rsigma_r))
             (assumptions rb_r)) ->
      every_nth
        (fun(ass : sequent V L) =>
           provable (GC_n_set V L 1)
             (reordered_sequent_list_set
                (map (subst_sequent rsigma_l) (assumptions rb_l) ++
                 map (subst_sequent rsigma_r) (assumptions rb_r)))
             (subst_sequent cut_sigma ass))
        (assumptions cut_r)
      ->
        every_nth
          (provable (GRC_n_set rules (S n)) (empty_sequent_set V L))
          (map (subst_sequent (subst_compose inj_sigma cut_sigma)) 
               (assumptions cut_r)).
  Proof.
    intros rules n rb_l rb_r cut_r rsigma_l rsigma_r inj_sigma cut_sigma 
           H H0 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10. 
    apply every_nth_map.
    intros i i_less.
    specialize (H10 i i_less).
    simpl in *.
    rewrite subst_sequent_compose.
    apply proof_mono_rules with (rules2 := GRC_n_set rules 1) in H10.
      eapply GRC_n_substitution_lemma 
             with (sigma := inj_sigma)(k := n) in H10; auto.
        apply plug_hypothesis_proof in H10.
          apply plug_empty_hypothesis_proof in H10.
            trivial.
          clear i i_less H10.
          intros hsub H10.
          eapply proof_mono_rules.
            apply GR_n_subset_GRC_n.
          unfold subst_sequent_set, reordered_sequent_list_set in *.
          decompose [ex and] H10; clear H10.
          rename x into h, x0 into h'.
          subst hsub.
          eapply provable_GR_n_list_reorder.
            apply list_reorder_symm.
            apply list_reorder_subst_sequent.
            eexact H12.
          apply in_app_or in H14.
          destruct H14.
            eapply every_nth_In.
              eexact H8.
            rewrite map_ext with (g := fun s => 
                       subst_sequent inj_sigma (subst_sequent rsigma_l s)).
              rewrite <- map_map.
              apply in_map.
              trivial.
            intros a.
            apply subst_sequent_compose.
          eapply every_nth_In.
            eexact H9.
          rewrite map_ext with (g := fun s => 
                     subst_sequent inj_sigma (subst_sequent rsigma_r s)).
            rewrite <- map_map.
            apply in_map.
            trivial.
          intros a.
          apply subst_sequent_compose.
        clear - v_eq H H0 H1 H7.
        intros h H2.
        eapply proof_mono_rules.
          apply GR_n_subset_GRC_n.
        eapply syntactic_GR_n_provable_subst_Ax with (1 := v_eq); eauto.
      clear - H0 H2 H3 H4 H5.
      apply rank_sequent_set_sequent_list_set.
      apply every_nth_append.
        eapply one_step_rule_propositional_subst_assumptions; eauto.
      eapply one_step_rule_propositional_subst_assumptions; eauto.
    apply GC_n_subset_GRC_n.
  Qed.

  Lemma syntactic_GR_n_prove_cut_absorb_conclusion :
    forall(rules : set (sequent_rule V L))(n : nat)
          (cut_r : sequent_rule V L)
          (inj_sigma cut_sigma : lambda_subst V L),
      one_step_rule_set rules ->
      rules cut_r ->
      renaming cut_sigma ->
      rank_subst (S n) inj_sigma ->
      every_nth (provable (GR_n_set rules (S n)) (empty_sequent_set V L))
        (map (subst_sequent (subst_compose inj_sigma cut_sigma)) 
           (assumptions cut_r))
      ->
         provable (GR_n_set rules (2 + n)) (empty_sequent_set V L)
           (subst_sequent (subst_compose inj_sigma cut_sigma) 
                          (conclusion cut_r)).
  Proof.
    intros rules n cut_r inj_sigma cut_sigma H H0 H1 H2 H3.
    apply every_nth_mono with 
          (Q := provable (GR_n_set rules (2 + n)) (empty_sequent_set V L))
          in H3.
    apply provable_with_rule with (2 := H3).
      clear H3.
      split.
        right.
        unfold weaken_subst_rule in *.
        simpl.
        eexists.
        eexists.
        exists [].
        repeat split; eauto.
        rewrite app_nil_r.
        apply list_reorder_refl.
      split.
        simpl.
        apply rank_subst_assumptions.
          auto.
        eapply rank_subst_ge.
          apply le_n_Sn.
        eapply rank_subst_subst_compose; eauto.
        apply rank_renaming.
        trivial.
      simpl.
      apply rank_subst_conclusion.
          apply lt_n_S.
          apply lt_0_Sn.
        auto.
      simpl.
      eapply rank_subst_subst_compose; eauto.
      apply rank_renaming.
      trivial.
    clear. 
    intros s H.
    eapply proof_mono_rules.
      apply rank_rules_subset_rank.
      apply (le_n_Sn (S n)).
    trivial.
  Qed.

  Lemma syntactic_GR_n_cut_eli_two_osr_concl :
    forall(rules : set (sequent_rule V L))(n : nat)(ssn_pos : 0 < 2 + n)
          (f : lambda_formula V L)(q r : sequent V L)
          (rb_l rb_r : sequent_rule V L)(sigma_l sigma_r : lambda_subst V L)
          (delta_l delta_r concl_l_tl concl_r_tl : sequent V L),
      countably_infinite V ->
      one_step_rule_set rules ->
      absorbs_congruence rules ->
      absorbs_cut op_eq v_eq rules ->
      (forall(s : sequent V L)(f : lambda_formula V L),
         provable (GR_n_set rules (2 + n)) (empty_sequent_set V L) 
                  (f :: f :: s) ->
           provable (GR_n_set rules (2 + n)) (empty_sequent_set V L) (f :: s)) 
      ->
      (forall(s : sequent V L),
         provable (GRC_n_set rules (S n)) (empty_sequent_set V L) s ->
           provable (GR_n_set rules (S n)) (empty_sequent_set V L) s) ->
      rules rb_l -> rules rb_r ->
      rank_subst (S n) sigma_l -> rank_subst (S n) sigma_r ->
      rank_sequent (2 + n) delta_l -> rank_sequent (2 + n) delta_r ->
      list_reorder (f :: q)
                   (subst_sequent sigma_l (conclusion rb_l) ++ delta_l) ->
      list_reorder (f :: concl_l_tl)
                   (subst_sequent sigma_l (conclusion rb_l)) ->
      list_reorder ((lf_neg f) :: r)
                   (subst_sequent sigma_r (conclusion rb_r) ++ delta_r) ->
      list_reorder ((lf_neg f) :: concl_r_tl)
                   (subst_sequent sigma_r (conclusion rb_r)) ->
      every_nth
           (provable (GR_n_set rules (S n)) (empty_sequent_set V L))
           (map (subst_sequent sigma_l) (assumptions rb_l)) ->
      every_nth
           (provable (GR_n_set rules (S n)) (empty_sequent_set V L))
           (map (subst_sequent sigma_r) (assumptions rb_r)) ->
        provable (G_n_set V L (2 + n))
                 (provable_subst_n_conclusions rules (2 + n) ssn_pos) 
          (q ++ r).
  Proof.
    intros rules n ssn_pos fsub q r rb_l rb_r sigma_l sigma_r 
           delta_l delta_r concl_l_tl concl_r_tl 
           H H0 H1 H2 H3 H4 H5 H6 H7 H8 H9 H10 H11 H12 H13 H14 H15 H16. 
    apply countably_infinite_non_empty with (X := V); trivial.
    intros nonempty_V.
    rewrite <- GR_n_provable_with_premises with (npos := ssn_pos); trivial.
    (* have now   GR (2+n) |- q ++ r 
     * weaken to  GR (2+n) |- concl_l_tl ++ concl_r_tl
     *)
    eapply provable_GR_n_list_reorder.
      apply list_reorder_symm.
      eapply list_reorder_trans.
        apply list_reorder_append_both.
          eapply list_reorder_tail_head.
          eapply list_reorder_trans.
            eexact H11.
          eapply list_reorder_trans.
            apply list_reorder_append_right.
            apply list_reorder_symm.
            eexact H12.
          simpl.
          apply list_reorder_refl.
        eapply list_reorder_tail_head.
        eapply list_reorder_trans.
          eexact H13.
        eapply list_reorder_trans.
          apply list_reorder_append_right.
          apply list_reorder_symm.
          eexact H14.
        simpl.
        apply list_reorder_refl.
      rewrite app_assoc_reverse.
      apply list_reorder_append_left.
      apply list_reorder_append_3_middle.
    rewrite app_assoc.
    apply list_weakening_admissible_GR_n; auto.
      apply rank_sequent_append; trivial.
    clear q r delta_l delta_r H9 H10 H11 H13.
    (* have now   GR (2+n) |- concl_l_tl ++ concl_r_tl
     * get common injective substitution and the preimage f of fsub
     *)
    eapply syntactic_GR_n_get_cut_rule 
           with (rules := rules)(8 := H12)(9 := H14) in H2; eauto.
    decompose [ex and] H2; clear H2.
    rename x into rsigma_l, x0 into rsigma_r, x1 into inj_sigma, 
           x2 into cut_sigma, x3 into cut_r, x4 into concl_l, x5 into concl_r.
    eapply syntactic_GR_n_prove_cut_absorb_assumptions in H27; eauto.
        apply every_nth_mono with (1 := H4) in H27.
        clear - nonempty_V H0 H3 H11 H13 H17 H18 H19 H20 H21 H22 H25 H27.
        apply syntactic_GR_n_prove_cut_absorb_conclusion in H27; trivial.
        unfold multi_subset in *.
        destruct H25 as [delta].
        assert (list_reorder
                  (sequent_support op_eq v_eq 
                        (subst_sequent (subst_compose inj_sigma cut_sigma) 
                                       (conclusion cut_r))
                   ++ (subst_sequent inj_sigma delta))
                  (concl_l_tl ++ concl_r_tl)).
          clear H3 H27.
          subst concl_l_tl concl_r_tl.
          rewrite <- subst_sequent_append.
          rewrite subst_sequent_compose.
          rewrite sequent_support_subst_sequent.
              rewrite <- subst_sequent_append.
              apply list_reorder_map.
              trivial.
            trivial.
          eapply one_step_rule_simple_modal_conclusion_subst_reorder; eauto.
          apply list_reorder_refl.
        eapply provable_GR_n_list_reorder.
          eexact H1.
        apply list_weakening_admissible_GR_n with (1 := v_eq)(2 := nonempty_V);
                   trivial.
            apply lt_0_Sn.
          eapply rank_sequent_subst_add.
                eapply rank_sequent_append_right.
                eapply rank_sequent_list_reorder.
                  eexact H.
                apply rank_sequent_append; eauto.
              eexact H13.
            apply le_n_S.
            apply le_0_n.
          trivial.
        apply syntactic_support_contraction; trivial.
      rewrite <- H23.
      trivial.
    rewrite <- H24.
    trivial.
  Qed.


  (***************************************************************************)
  (** *** Combine proofs for case a) *)
  (***************************************************************************)

  Lemma syntactic_GR_n_cut_eli_two_osr :
    forall(rules : set (sequent_rule V L))(n : nat)(ssn_pos : 0 < 2 + n)
          (f : lambda_formula V L)(r q : sequent V L),
      countably_infinite V ->
      one_step_rule_set rules ->
      absorbs_cut op_eq v_eq rules ->
      absorbs_congruence rules ->
      (forall(s : sequent V L)(f : lambda_formula V L),
         provable (GR_n_set rules (2 + n)) (empty_sequent_set V L) 
                  (f :: f :: s) ->
           provable (GR_n_set rules (2 + n)) (empty_sequent_set V L) (f :: s)) 
      ->
      (forall(s : sequent V L),
         provable (GRC_n_set rules (S n)) (empty_sequent_set V L) s ->
           provable (GR_n_set rules (S n)) (empty_sequent_set V L) s) ->
      provable_subst_n_conclusions rules (2 + n) ssn_pos (f :: q) ->
      provable_subst_n_conclusions rules (2 + n) ssn_pos (lf_neg f :: r) ->
        provable (G_n_set V L (2 + n))
                 (provable_subst_n_conclusions rules (2 + n) ssn_pos) 
          (q ++ r).
  Proof.
    intros rules n ssn_pos f r q H H0 H1 H2 H3 H4 H5 H6.
    unfold provable_subst_n_conclusions in H5, H6.
    unfold rank_weaken_subst_rule in H5, H6.
    decompose [ex and] H5; clear H5.
    rename x into r_l, x0 into rb_l, x1 into sigma_l, x2 into delta_l.
    rewrite <- H12 in *.
    assert (H15 := list_reorder_single_append _ _ _ _ H13).
    decompose [ex and] H6; clear H6.
    rename x into r_r, x0 into rb_r, x1 into sigma_r, x2 into delta_r.
    rewrite <- H19 in *.
    assert (H22 := list_reorder_single_append _ _ _ _ H20).
    destruct H15.
      destruct H22.
        destruct H6 as [concl_l_tl].
        destruct H15 as [concl_r_tl].
        eapply syntactic_GR_n_cut_eli_two_osr_concl
               with (13 := H13)(16 := H15); eauto.
          rewrite <- H11.
          trivial.
        rewrite <- H18.
        trivial.
      assert (provable_subst_n_conclusions rules (2 + n) ssn_pos (q ++ r)).
        eapply multiset_provable_subst_n_conclusions with (s := r ++ q).
          destruct H15 as [delta_r_tl].
          eapply cut_elimination_osr_context with (5 := H20); eauto.
            rewrite <- H18.
            trivial.
          eapply rank_sequent_tail.
          apply rank_sequent_osr_subst_conclusion with (4 := H13); auto.
        apply list_reorder_append_swap.
      exists (assume _ _ _ H16).
      trivial.
    assert (provable_subst_n_conclusions rules (2 + n) ssn_pos (q ++ r)).
      destruct H6 as [delta_l_tl].
      eapply cut_elimination_osr_context with (5 := H13); eauto.
        rewrite <- H11.
        trivial.
      eapply rank_sequent_tail.
      apply rank_sequent_osr_subst_conclusion with (4 := H20); auto.
    exists (assume _ _ _ H15).
    trivial.
  Qed.

End OSR_cut.
