(* 
 * Formalized Cut Elimination in Coalgebraic Logics
 * 
 * Copyright (C) 2013 - 2013 Hendrik Tews
 * 
 * This file is part of my formalization of "Cut Elimination in 
 * Coalgebraic Logics" by Dirk Pattinson and Lutz Schroeder.
 * 
 * The formalization is free software: you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * The formalization is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License in file COPYING in this or one of the parent
 * directories for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with the formalization in the file COPYING. 
 * If not, see <http://www.gnu.org/licenses/>.
 * 
 * $Id: plain_prop_mod.v,v 1.7 2013/04/10 11:17:16 tews Exp $
 *)

(** ** Formulas Prop(Lambda(S)) or V

      The proof of 5.6 uses a set of formulas whoose members are
      either propositional variables or modal formulas. 
*)

Require Export modal_formulas.

Section Plain_prop_mod.

  Variable V : Type.
  Variable L : modal_operators.


  (***************************************************************************)
  (** *** Plain propositional or modal formulas
         Used in the proof of 5.6 *)
  (***************************************************************************)

  (** This is almost the same as prop_or_mod_formula, only that in the 
      latter a single negation is permitted.
   *)
  Definition plain_prop_or_mod_formula : set (lambda_formula V L) :=
    union prop_form modal_form.


  Definition plain_prop_mod_subst(subst : lambda_subst V L) : Prop :=
    forall(v : V), plain_prop_or_mod_formula (subst v).

  Lemma plain_prop_mod_id_subst : plain_prop_mod_subst id_subst.
  Proof.
    intros v.
    left.
    simpl.
    trivial.
  Qed.

  Lemma plain_prop_mod_subst_update :
    forall(v_eq : eq_type V)(sigma : lambda_subst V L)
          (v : V)(f : lambda_formula V L),
      plain_prop_or_mod_formula f ->
      plain_prop_mod_subst sigma ->
        plain_prop_mod_subst (function_update v_eq sigma v f).
  Proof.
    unfold plain_prop_mod_subst in *.
    intros v_eq sigma v f H H0 v0.
    apply function_update_split.
      trivial.
    intros H1.
    apply H0.
  Qed.

End Plain_prop_mod.

Implicit Arguments plain_prop_or_mod_formula [V L].
Implicit Arguments plain_prop_mod_subst [V L].
