(* 
 * Formalized Cut Elimination in Coalgebraic Logics
 * 
 * Copyright (C) 2013 - 2013 Hendrik Tews
 * 
 * This file is part of my formalization of "Cut Elimination in 
 * Coalgebraic Logics" by Dirk Pattinson and Lutz Schroeder.
 * 
 * The formalization is free software: you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * The formalization is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License in file COPYING in this or one of the parent
 * directories for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with the formalization in the file COPYING. 
 * If not, see <http://www.gnu.org/licenses/>.
 * 
 * $Id: prop_cut.v,v 1.6 2013/04/10 12:06:16 tews Exp $
 *)


(** ** Cut elimination case c, part of 5.6.3

      This module proves case c) in the syntactic cut-elimination
      proof. This is the case of a cut between two propositional
      rules. The proof reuses intermediate lemmas from the
      propositional cut elimination in module
      #<A HREF="propositional_properties.html"><spanclass="inlinecode">propositional_properties</span></A>#. 
 *)

Require Export contraction.


Section Prop_cut.

  Variable V : Type.
  Variable L : modal_operators.

  Variable op_eq : eq_type (operator L).
  Variable v_eq : eq_type V.


  Lemma syntactic_GR_n_cut_two_prop :
    forall(rules : set (sequent_rule V L))(n m sd : nat)(ssn_pos : 0 < 2 + n)
          (f : lambda_formula V L)(r q : sequent V L)
          (f_rule negf_rule : sequent_rule V L)
          (Hf : G_n_set V L (2 + n) f_rule)
          (Hnf : G_n_set V L (2 + n) negf_rule)
          (f_sub : 
             dep_list (sequent V L)
                      (proof (G_n_set V L (2 + n))
                          (provable_subst_n_conclusions rules (2 + n) ssn_pos))
                      (assumptions f_rule))
          (negf_sub : 
             dep_list (sequent V L)
                      (proof (G_n_set V L (2 + n))
                          (provable_subst_n_conclusions rules (2 + n) ssn_pos))
                      (assumptions negf_rule)),
      countably_infinite V ->
      absorbs_congruence rules ->
      absorbs_contraction op_eq v_eq rules ->
      one_step_rule_set rules ->
      (forall(s : sequent V L),
           provable (GRC_n_set rules (S n)) (empty_sequent_set V L) s ->
             provable (GR_n_set rules (S n)) (empty_sequent_set V L) s) ->
      (forall(f : lambda_formula V L)(r q : sequent V L),
         provable (G_n_set V L (2 + n)) 
                  (provable_subst_n_conclusions rules (2 + n) ssn_pos)
                  (f :: q) ->
         provable (G_n_set V L (2 + n))
                  (provable_subst_n_conclusions rules (2 + n) ssn_pos)
                  (lf_neg f :: r) ->
         formula_measure f < m ->
           provable (G_n_set V L (2 + n))
                    (provable_subst_n_conclusions rules (2 + n) ssn_pos) 
                    (q ++ r)) ->
      (forall(f : lambda_formula V L)(r q : sequent V L)
             (p_fq : proof (G_n_set V L (2 + n))
                           (provable_subst_n_conclusions rules (2 + n) ssn_pos)
                           (f :: q))
             (p_nfr : proof (G_n_set V L (2 + n))
                            (provable_subst_n_conclusions rules (2 + n) ssn_pos)
                            (lf_neg f :: r)),
         proof_depth p_fq + proof_depth p_nfr <= sd ->
         formula_measure f < S m ->
           provable (G_n_set V L (2 + n))
                    (provable_subst_n_conclusions rules (2 + n) ssn_pos) 
                    (q ++ r)) ->
      formula_measure f < S m ->
      proof_depth (rule (G_n_set V L (2 + n))
                        (provable_subst_n_conclusions rules (2 + n) ssn_pos)
                        f_rule Hf f_sub)
        + proof_depth (rule (G_n_set V L (2 + n))
                            (provable_subst_n_conclusions rules (2 + n) ssn_pos)
                            negf_rule Hnf negf_sub)
         <= S sd ->
      conclusion f_rule = f :: q ->
      conclusion negf_rule = lf_neg f :: r ->
        provable (G_n_set V L (2 + n))
          (provable_subst_n_conclusions rules (2 + n) ssn_pos) 
          (q ++ r).
  Proof.
    intros rules n m sd ssn_pos f r q f_rule negf_rule Hf Hnf 
           f_sub negf_sub H H0 H1 H2 H3 H4 H5 H6 H7 H8 H9.
    assert (provable (G_n_set V L (2 + n)) 
                     (provable_subst_n_conclusions rules (2 + n) ssn_pos) 
              (lf_neg f :: r)).
      rewrite <- H9.
      exists (rule _ _ _ Hnf negf_sub).
      trivial.
    decompose [or] (decompose_G_n_set_coarsly _ _ Hf).
      clear H3 H4 H5 H7.
      rewrite H8 in *.
      apply G_n_cut_elim_head_ax with (f := f); trivial.
                apply rank_sequent_set_provable_subst_n_conclusions.
                  apply lt_n_S.
                  apply lt_0_Sn.
                trivial.
              apply multiset_provable_subst_n_conclusions.
            apply bounded_weakening_provable_subst_n_conclusions.
          apply head_inversion_provable_subst_n_conclusion.
          trivial.
        eapply rank_sequent_tail.
        apply H11.
      apply H11.
    decompose [ex and] H11; clear H11.
    rename x into fb_rule, x0 into sl, x1 into sr.
    clear H12.
    assert (provable (G_n_set V L (2 + n)) 
                     (provable_subst_n_conclusions rules (2 + n) ssn_pos) 
              (f :: q)).
      rewrite <- H8.
      exists (rule _ _ _ Hf f_sub).
      trivial.
    rewrite H14 in H8, H13.
    unfold rule_add_context in H8, H13.
    simpl in H8, H13.
    unfold add_context in *.
    destruct sl.
      clear Hf Hnf negf_sub H5 H7.
      subst f_rule.
      unfold rule_add_context in *.
      simpl in f_sub.
      rewrite <- H17 in H8.
      simpl in H8.
      inversion H8; clear H8.
      subst x2 sr.
      decompose [ex or] H15; clear H15.
          eapply G_n_cut_elim_head_and_inside; eauto.
                apply multiset_provable_subst_n_conclusions.
              apply head_inversion_provable_subst_n_conclusion.
              trivial.
            eapply head_contraction_closed_provable_subst_n_conclusions_ind;
                   eauto.
          clear - f_sub.
          intros i i_less.
          exists (dep_nth _ f_sub i i_less).
          trivial.
        eapply G_n_cut_elim_head_neg_and_inside; eauto.
          apply multiset_provable_subst_n_conclusions.
        apply head_inversion_provable_subst_n_conclusion.
        trivial.
      clear f_sub.
      unfold bare_neg_neg_rule, add_context in *.
      subst fb_rule.
      simpl in *.
      inversion H17; clear H17.
      subst f.
      eapply G_n_cut_elim_head_neg_neg_inside; eauto.
        apply multiset_provable_subst_n_conclusions.
      apply head_inversion_provable_subst_n_conclusion.
      trivial.
    clear H H0 H1 H3 H4 x2 H17.
    simpl in H8, H13.
    inversion H8; clear H8.
    subst l.
    repeat rewrite app_assoc_reverse.
    apply provable_with_rule with 
           (s := add_context sl (sr ++ r) (conclusion fb_rule))
           (assum := map (add_context sl (sr ++ r)) (assumptions fb_rule)).
      apply sequent_other_context_G_n_set 
                          with (sl1 := f :: sl)(sr1 := sr); auto.
        clear. 
        intros H.
        apply rank_sequent_tail in H.
        trivial.
      clear - Hnf H9.
      intros H.
      apply rank_sequent_append.
        trivial.
      apply rank_sequent_tail with (f := lf_neg f).
      rewrite <- H9.
      apply Hnf.
    remember (proof_depth (rule _ _ _ Hnf negf_sub)) as pdnf eqn:H16.
    assert (proof_depth (rule _ _ _ Hf f_sub) <= S sd - pdnf).
      clear - H7.
      omega.
    clear H7.
    destruct (S sd - pdnf) as [| pdaf] eqn:H17.
      eapply proof_depth_0.
      eexact H.
    apply proof_depth_rule_le_inv in H.
    apply every_nth_exists_inv in H.
    clear Hf f_sub.
    subst f_rule.
    unfold rule_add_context in *.
    simpl in H.
    assert (forall(q : sequent V L),
              provable_at_depth (G_n_set V L (2 + n)) 
                   (provable_subst_n_conclusions rules (2 + n) ssn_pos)
                   pdaf (f :: q) ->
                provable (G_n_set V L (2 + n)) 
                  (provable_subst_n_conclusions rules (2 + n) ssn_pos)
                  (q ++ r)).
      clear - H5 H6 H16 H9 H17.
      intros q H.
      destruct H as [p_fq].
      specialize (H5 _ r _ p_fq).
      rewrite <- H9 in H5.
      apply H5 with (p_nfr := rule _ _ _ Hnf negf_sub); trivial.
      omega.
    clear H5.
    decompose [ex or] H15; clear H15.
        eapply G_n_cut_elim_head_and_outside; eauto.
      eapply G_n_cut_elim_head_neg_and_outside; eauto.
    eapply G_n_cut_elim_head_neg_neg_outside; eauto.
  Qed.

End Prop_cut.

