
open Strange_t
open Strange_type_descr

open Memcheck

let flags = [Channel stdout; Verbose_statistics; 
	     Start_indent 2]
(* 
 * let flags = [Channel stdout; Verbose_blocks; Verbose_types;
 * 	     Verbose_statistics;
 * 	     Verbose_spinner; Verbose_type_ids; Verbose_trace;
 * 	     Start_indent 2]
 *)

let type_expr = strange_type_descr int_type_descr

let a = B(B(A(0)))
let b = C(A(0), A(1,2))
let c = C(A(0), C(A(1,2), A((3,4),(5,6))))
;;

  Printf.eprintf "check strange a ... \n%!";
  assert(check flags a type_expr);
  Printf.eprintf "... survived !\n\n%!";

  Printf.eprintf "check strange b ... \n%!";
  assert(check flags b type_expr);
  Printf.eprintf "... survived !\n\n%!";

  Printf.eprintf "check strange c ... \n%!";
  assert(check flags c type_expr);
  Printf.eprintf "... survived !\n\n%!"


(*
   echo "open Memcheck;;" > test/strange_type_descr.ml
   camlp4o ./generate_type_descr.cmo test/strange_t.ml >> test/strange_type_descr.ml 
   ocamlopt.opt -I . -I test -o test/strange unix.cmxa memcheck.cmx test/strange_t.ml test/strange_type_descr.ml test/strange_test.ml
   test/strange
*)
